/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.JsonCodec;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

class SockJSSession
extends SockJSSocketBase
implements Shareable {
    private static final Logger log = LoggerFactory.getLogger(SockJSSession.class);
    private final LocalMap<String, SockJSSession> sessions;
    private final Deque<String> pendingWrites = new LinkedList<String>();
    private List<Handler<AsyncResult<Void>>> writeAcks;
    private final Context context;
    private final InboundBuffer<Buffer> pendingReads;
    private TransportListener listener;
    private boolean closed;
    private boolean openWritten;
    private final String id;
    private final long timeout;
    private final Handler<SockJSSocket> sockHandler;
    private long heartbeatID;
    private long timeoutTimerID = -1L;
    private int maxQueueSize = 65536;
    private int messagesSize;
    private Handler<Void> drainHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean handleCalled;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private String uri;
    private MultiMap headers;
    private Context transportCtx;

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, long heartbeatInterval, Handler<SockJSSocket> sockHandler) {
        this(vertx, sessions, rc, null, -1L, heartbeatInterval, sockHandler);
    }

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, String id, long timeout, long heartbeatInterval, Handler<SockJSSocket> sockHandler) {
        super(vertx, rc.session(), rc.user());
        this.sessions = sessions;
        this.id = id;
        this.timeout = timeout;
        this.sockHandler = sockHandler;
        this.context = vertx.getOrCreateContext();
        this.pendingReads = new InboundBuffer(this.context);
        this.heartbeatID = vertx.setPeriodic(heartbeatInterval, tid -> {
            if (this.listener != null) {
                this.listener.sendFrame("h", null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Buffer buffer, Handler<AsyncResult<Void>> handler) {
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            if (this.closed) {
                if (handler != null) {
                    this.context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION)));
                }
                return;
            }
            String msgStr = buffer.toString();
            this.pendingWrites.add(msgStr);
            this.messagesSize += msgStr.length();
            if (handler != null) {
                if (this.writeAcks == null) {
                    this.writeAcks = new ArrayList<Handler<AsyncResult<Void>>>();
                }
                this.writeAcks.add(handler);
            }
            if (this.listener != null) {
                Context ctx = this.transportCtx;
                if (Vertx.currentContext() != ctx) {
                    ctx.runOnContext(v -> this.writePendingMessages());
                } else {
                    this.writePendingMessages();
                }
            }
        }
    }

    @Override
    public synchronized SockJSSession handler(Handler<Buffer> handler) {
        this.pendingReads.handler(handler);
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.pendingReads.fetch(amount);
        return this;
    }

    @Override
    public synchronized SockJSSession pause() {
        this.pendingReads.pause();
        return this;
    }

    @Override
    public synchronized SockJSSession resume() {
        this.pendingReads.resume();
        return this;
    }

    @Override
    public synchronized SockJSSession setWriteQueueMaxSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("maxQueueSize must be >= 1");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return this.messagesSize >= this.maxQueueSize;
    }

    @Override
    public synchronized SockJSSession drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized SockJSSession exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized SockJSSession endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            if (!this.closed) {
                this.closed = true;
                this.handleClosed();
            }
            this.doClose();
        }
    }

    private synchronized void doClose() {
        Context ctx = this.transportCtx;
        if (ctx != Vertx.currentContext()) {
            ctx.runOnContext(v -> this.doClose());
        } else if (this.listener != null && this.handleCalled) {
            this.listener.sessionClosed();
        }
    }

    @Override
    public synchronized SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public synchronized SocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public synchronized MultiMap headers() {
        return this.headers;
    }

    @Override
    public synchronized String uri() {
        return this.uri;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void resetListener() {
        this.listener = null;
        this.setTimer();
    }

    private void cancelTimer() {
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
    }

    private void setTimer() {
        if (this.timeout != -1L) {
            this.cancelTimer();
            this.timeoutTimerID = this.vertx.setTimer(this.timeout, id1 -> {
                this.vertx.cancelTimer(this.heartbeatID);
                if (this.listener == null) {
                    this.shutdown();
                }
                if (this.listener != null) {
                    this.listener.close();
                }
            });
        }
    }

    private synchronized void writePendingMessages() {
        if (this.listener != null) {
            String json = JsonCodec.encode(this.pendingWrites.toArray(new String[0]));
            this.pendingWrites.clear();
            if (this.writeAcks != null) {
                List<Handler<AsyncResult<Void>>> acks = this.writeAcks;
                this.writeAcks = null;
                this.listener.sendFrame("a" + json, (Handler<AsyncResult<Void>>)((Handler)ar -> acks.forEach(a -> a.handle(ar))));
            } else {
                this.listener.sendFrame("a" + json, null);
            }
            this.messagesSize = 0;
            if (this.drainHandler != null) {
                Handler<Void> dh = this.drainHandler;
                this.drainHandler = null;
                this.context.runOnContext(dh);
            }
        }
    }

    synchronized Context context() {
        return this.transportCtx;
    }

    synchronized void register(HttpServerRequest req, TransportListener lst) {
        this.transportCtx = this.vertx.getOrCreateContext();
        this.localAddress = req.localAddress();
        this.remoteAddress = req.remoteAddress();
        this.uri = req.uri();
        this.headers = BaseTransport.removeCookieHeaders(req.headers());
        if (this.closed) {
            this.writeClosed(lst);
            lst.close();
        } else if (this.listener != null) {
            this.writeClosed(lst, 2010, "Another connection still open");
            lst.close();
        } else {
            this.cancelTimer();
            this.listener = lst;
            if (!this.openWritten) {
                this.writeOpen(lst);
                this.sockHandler.handle((Object)this);
                this.handleCalled = true;
            }
            if (this.listener != null) {
                if (this.closed) {
                    this.writeClosed(lst);
                    this.listener = null;
                    lst.close();
                } else if (!this.pendingWrites.isEmpty()) {
                    this.writePendingMessages();
                }
            }
        }
    }

    void shutdown() {
        super.close();
        if (this.heartbeatID != -1L) {
            this.vertx.cancelTimer(this.heartbeatID);
        }
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
        if (this.id != null) {
            this.sessions.remove((Object)this.id);
        }
        if (!this.closed) {
            this.closed = true;
            this.handleClosed();
        }
    }

    private void handleClosed() {
        Handler<Void> handler2;
        this.pendingReads.clear();
        this.pendingWrites.clear();
        if (this.writeAcks != null) {
            this.writeAcks.forEach(handler -> this.context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION))));
            this.writeAcks.clear();
        }
        if ((handler2 = this.endHandler) != null) {
            this.context.runOnContext(arg_0 -> handler2.handle(arg_0));
        }
    }

    synchronized boolean handleMessages(String messages) {
        List<String> msgList = JsonCodec.decodeValues(messages);
        if (msgList == null) {
            return false;
        }
        this.handleMessages(msgList);
        return true;
    }

    private synchronized void handleMessages(List<String> messages) {
        if (this.context == Vertx.currentContext()) {
            for (String msg : messages) {
                this.pendingReads.write((Object)Buffer.buffer((String)msg));
            }
        } else {
            this.context.runOnContext(v -> this.handleMessages(messages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Handler<Throwable> eh;
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            eh = this.exceptionHandler;
        }
        if (eh != null) {
            this.context.runOnContext(v -> eh.handle((Object)t));
        } else {
            log.error((Object)"Unhandled exception", t);
        }
    }

    void writeClosed(TransportListener lst) {
        this.writeClosed(lst, 3000, "Go away!");
    }

    private void writeClosed(TransportListener lst, int code, String msg) {
        String sb = "c[" + code + ",\"" + msg + "\"]";
        lst.sendFrame(sb, null);
    }

    private synchronized void writeOpen(TransportListener lst) {
        lst.sendFrame("o", null);
        this.openWritten = true;
    }
}

