/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RoutingContextImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import io.vertx.ext.web.impl.RoutingContextWrapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;

public class RouterImpl
implements Router {
    private static final Comparator<RouteImpl> routeComparator = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    private static final Logger log = LoggerFactory.getLogger(RouterImpl.class);
    private final Vertx vertx;
    private final Set<RouteImpl> routes = new ConcurrentSkipListSet<RouteImpl>(routeComparator);
    private final AtomicInteger orderSequence = new AtomicInteger();
    private Map<Integer, Handler<RoutingContext>> errorHandlers = new ConcurrentHashMap<Integer, Handler<RoutingContext>>();
    private Handler<Router> modifiedHandler;

    public RouterImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    public void handle(HttpServerRequest request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Router: " + System.identityHashCode(this) + " accepting request " + request.method() + " " + request.absoluteURI()));
        }
        new RoutingContextImpl(null, this, request, this.routes).next();
    }

    @Override
    public Route route() {
        return new RouteImpl(this, this.orderSequence.getAndIncrement());
    }

    @Override
    public Route route(HttpMethod method, String path) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, path);
    }

    @Override
    public Route route(String path) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), path);
    }

    @Override
    public Route routeWithRegex(HttpMethod method, String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, regex, true);
    }

    @Override
    public Route routeWithRegex(String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), regex, true);
    }

    @Override
    public Route get() {
        return this.route().method(HttpMethod.GET);
    }

    @Override
    public Route get(String path) {
        return this.route(HttpMethod.GET, path);
    }

    @Override
    public Route getWithRegex(String path) {
        return this.route().method(HttpMethod.GET).pathRegex(path);
    }

    @Override
    public Route head() {
        return this.route().method(HttpMethod.HEAD);
    }

    @Override
    public Route head(String path) {
        return this.route(HttpMethod.HEAD, path);
    }

    @Override
    public Route headWithRegex(String path) {
        return this.route().method(HttpMethod.HEAD).pathRegex(path);
    }

    @Override
    public Route options() {
        return this.route().method(HttpMethod.OPTIONS);
    }

    @Override
    public Route options(String path) {
        return this.route(HttpMethod.OPTIONS, path);
    }

    @Override
    public Route optionsWithRegex(String path) {
        return this.route().method(HttpMethod.OPTIONS).pathRegex(path);
    }

    @Override
    public Route put() {
        return this.route().method(HttpMethod.PUT);
    }

    @Override
    public Route put(String path) {
        return this.route(HttpMethod.PUT, path);
    }

    @Override
    public Route putWithRegex(String path) {
        return this.route().method(HttpMethod.PUT).pathRegex(path);
    }

    @Override
    public Route post() {
        return this.route().method(HttpMethod.POST);
    }

    @Override
    public Route post(String path) {
        return this.route(HttpMethod.POST, path);
    }

    @Override
    public Route postWithRegex(String path) {
        return this.route().method(HttpMethod.POST).pathRegex(path);
    }

    @Override
    public Route delete() {
        return this.route().method(HttpMethod.DELETE);
    }

    @Override
    public Route delete(String path) {
        return this.route(HttpMethod.DELETE, path);
    }

    @Override
    public Route deleteWithRegex(String path) {
        return this.route().method(HttpMethod.DELETE).pathRegex(path);
    }

    @Override
    public Route trace() {
        return this.route().method(HttpMethod.TRACE);
    }

    @Override
    public Route trace(String path) {
        return this.route(HttpMethod.TRACE, path);
    }

    @Override
    public Route traceWithRegex(String path) {
        return this.route().method(HttpMethod.TRACE).pathRegex(path);
    }

    @Override
    public Route connect() {
        return this.route().method(HttpMethod.CONNECT);
    }

    @Override
    public Route connect(String path) {
        return this.route(HttpMethod.CONNECT, path);
    }

    @Override
    public Route connectWithRegex(String path) {
        return this.route().method(HttpMethod.CONNECT).pathRegex(path);
    }

    @Override
    public Route patch() {
        return this.route().method(HttpMethod.PATCH);
    }

    @Override
    public Route patch(String path) {
        return this.route(HttpMethod.PATCH, path);
    }

    @Override
    public Route patchWithRegex(String path) {
        return this.route().method(HttpMethod.PATCH).pathRegex(path);
    }

    @Override
    public List<Route> getRoutes() {
        return new ArrayList<Route>(this.routes);
    }

    @Override
    public Router clear() {
        this.routes.clear();
        return this;
    }

    @Override
    public void handleContext(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    @Override
    public void handleFailure(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    @Override
    public Router modifiedHandler(Handler<Router> handler) {
        if (this.modifiedHandler == null) {
            this.modifiedHandler = handler;
        } else {
            Handler<Router> previousHandler = this.modifiedHandler;
            this.modifiedHandler = router -> {
                try {
                    previousHandler.handle(router);
                }
                catch (RuntimeException e) {
                    log.error((Object)"Router modified notification failed", (Throwable)e);
                }
                try {
                    handler.handle(router);
                }
                catch (RuntimeException e) {
                    log.error((Object)"Router modified notification failed", (Throwable)e);
                }
            };
        }
        return this;
    }

    @Override
    public Router mountSubRouter(String mountPoint, Router subRouter) {
        if (mountPoint.endsWith("*")) {
            throw new IllegalArgumentException("Don't include * when mounting subrouter");
        }
        this.route(mountPoint + "*").subRouter(subRouter);
        return this;
    }

    @Override
    @Deprecated
    public synchronized Router exceptionHandler(Handler<Throwable> exceptionHandler) {
        if (exceptionHandler != null) {
            this.errorHandler(500, (Handler<RoutingContext>)((Handler)routingContext -> exceptionHandler.handle((Object)routingContext.failure())));
        }
        return this;
    }

    @Override
    public Router errorHandler(int statusCode, Handler<RoutingContext> errorHandler) {
        Objects.requireNonNull(errorHandler);
        this.errorHandlers.put(statusCode, errorHandler);
        return this;
    }

    void add(RouteImpl route) {
        this.routes.add(route);
        if (this.modifiedHandler != null) {
            this.modifiedHandler.handle((Object)this);
        }
    }

    void remove(RouteImpl route) {
        this.routes.remove(route);
        if (this.modifiedHandler != null) {
            this.modifiedHandler.handle((Object)this);
        }
    }

    Vertx vertx() {
        return this.vertx;
    }

    Iterator<RouteImpl> iterator() {
        return this.routes.iterator();
    }

    Handler<RoutingContext> getErrorHandlerByStatusCode(int statusCode) {
        return this.errorHandlers.get(statusCode);
    }

    private String getAndCheckRoutePath(RoutingContext routingContext) {
        RoutingContextImplBase ctx = (RoutingContextImplBase)routingContext;
        Route route = ctx.currentRoute();
        if (route.getPath() != null && !route.isRegexPath()) {
            return route.getPath();
        }
        if (ctx.matchRest != -1) {
            if (ctx.matchNormalized) {
                return ctx.normalisedPath().substring(0, ctx.matchRest);
            }
            return ctx.request().path().substring(0, ctx.matchRest);
        }
        throw new IllegalStateException("Sub routers must be mounted on paths (constant or parameterized)");
    }
}

