/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.util.UUID;

public abstract class SockJSSocketBase
implements SockJSSocket {
    private final MessageConsumer<Buffer> registration;
    protected final Vertx vertx;
    protected Session webSession;
    protected User webUser;
    private final String writeHandlerID;

    @Override
    public abstract SockJSSocket exceptionHandler(Handler<Throwable> var1);

    protected SockJSSocketBase(Vertx vertx, Session webSession, User webUser) {
        this.vertx = vertx;
        this.webSession = webSession;
        this.webUser = webUser;
        Handler writeHandler = buff -> this.write((Buffer)buff.body());
        this.writeHandlerID = UUID.randomUUID().toString();
        this.registration = vertx.eventBus().consumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public void end() {
        this.registration.unregister();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.registration.unregister(handler);
    }

    @Override
    public void close() {
        this.end();
    }

    public void closeAfterSessionExpired() {
        this.close();
    }

    @Override
    public Session webSession() {
        return this.webSession;
    }

    @Override
    public User webUser() {
        return this.webUser;
    }
}

