/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;
import java.util.Base64;

public class BasicAuthHandlerImpl
extends AuthorizationAuthHandler {
    public BasicAuthHandlerImpl(AuthProvider authProvider, String realm) {
        super(authProvider, realm, AuthorizationAuthHandler.Type.BASIC);
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Base64.getDecoder().decode((String)parseAuthorization.result()));
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                context.fail(e);
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("username", suser).put("password", spass)));
        }));
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        return "Basic realm=\"" + this.realm + "\"";
    }
}

