/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;

public class ResponseContentTypeHandlerImpl
implements ResponseContentTypeHandler {
    private final String disableFlag;

    public ResponseContentTypeHandlerImpl(String disableFlag) {
        this.disableFlag = disableFlag;
    }

    public void handle(RoutingContext rc) {
        HttpServerResponse response = rc.response();
        response.headersEndHandler(v -> {
            if (rc.get(this.disableFlag) != null) {
                return;
            }
            String acceptableContentType = rc.getAcceptableContentType();
            if (acceptableContentType == null) {
                return;
            }
            MultiMap headers = rc.response().headers();
            if (headers.contains(HttpHeaders.CONTENT_TYPE)) {
                return;
            }
            if (!"0".equals(headers.get(HttpHeaders.CONTENT_LENGTH))) {
                headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)acceptableContentType);
            }
        });
        rc.next();
    }
}

