/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import java.util.List;
import java.util.regex.Pattern;

public class JWTAuthHandlerImpl
extends AuthHandlerImpl
implements JWTAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(JWTAuthHandlerImpl.class);
    private static final Pattern BEARER = Pattern.compile("^Bearer$", 2);
    private final String skip;
    private final JsonObject options;

    public JWTAuthHandlerImpl(AuthProvider authProvider, String skip) {
        super(authProvider);
        this.skip = skip;
        this.options = new JsonObject();
    }

    @Override
    public JWTAuthHandler setAudience(List<String> audience) {
        this.options.put("audience", new JsonArray(audience));
        return this;
    }

    @Override
    public JWTAuthHandler setIssuer(String issuer) {
        this.options.put("issuer", issuer);
        return this;
    }

    @Override
    public JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) {
        this.options.put("ignoreExpiration", Boolean.valueOf(ignoreExpiration));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handle(RoutingContext context) {
        User user = context.user();
        if (user != null) {
            this.authorise(user, context);
            return;
        }
        HttpServerRequest request = context.request();
        String token = null;
        if (request.method() == HttpMethod.OPTIONS && request.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS) != null) {
            for (String ctrlReq : request.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS).split(",")) {
                if (!ctrlReq.equalsIgnoreCase("authorization")) continue;
                context.next();
                return;
            }
        }
        if (this.skip != null && this.skip.contains(request.path())) {
            context.next();
            return;
        }
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            log.warn((Object)"No Authorization header was found");
            context.fail(401);
            return;
        }
        String[] parts = authorization.split(" ");
        if (parts.length != 2) {
            log.warn((Object)"Format is Authorization: Bearer [token]");
            context.fail(401);
            return;
        }
        String scheme = parts[0];
        String credentials = parts[1];
        if (BEARER.matcher(scheme).matches()) {
            token = credentials;
        }
        JsonObject authInfo = new JsonObject().put("jwt", token).put("options", this.options);
        this.authProvider.authenticate(authInfo, res -> {
            if (res.succeeded()) {
                User user2 = (User)res.result();
                context.setUser(user2);
                this.authorise(user2, context);
            } else {
                log.warn((Object)"JWT decode failure");
                context.fail(401);
            }
        });
    }
}

