/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl.parser;

import io.vertx.ext.web.validation.impl.parser.ValueParser;
import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ObjectParser<X> {
    private Map<String, ValueParser<X>> propertiesParsers;
    private Map<Pattern, ValueParser<X>> patternPropertiesParsers;
    protected ValueParser<X> additionalPropertiesParser;

    public ObjectParser(Map<String, ValueParser<X>> propertiesParsers, Map<Pattern, ValueParser<X>> patternPropertiesParsers, ValueParser<X> additionalPropertiesParser) {
        this.propertiesParsers = propertiesParsers;
        this.patternPropertiesParsers = patternPropertiesParsers;
        this.additionalPropertiesParser = additionalPropertiesParser;
    }

    protected Map.Entry<String, Object> parseField(String key, X serialized) {
        ValueParser valueParser = null;
        if (this.propertiesParsers != null && this.propertiesParsers.containsKey(key)) {
            valueParser = this.propertiesParsers.get(key);
        } else if (this.patternPropertiesParsers != null) {
            valueParser = this.patternPropertiesParsers.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(key).find()).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        if (valueParser == null) {
            valueParser = this.getAdditionalPropertiesParserIfRequired();
        }
        if (valueParser == null) {
            return null;
        }
        if (this.mustNullateValue(serialized, valueParser)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, null);
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, valueParser.parse(serialized));
    }

    protected abstract ValueParser<X> getAdditionalPropertiesParserIfRequired();

    protected abstract boolean mustNullateValue(X var1, ValueParser<X> var2);
}

