/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.BadRequestException;
import io.vertx.ext.web.validation.BodyProcessorException;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.RequestPredicate;
import io.vertx.ext.web.validation.RequestPredicateException;
import io.vertx.ext.web.validation.RequestPredicateResult;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.RequestParametersImpl;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ValidationHandlerImpl
implements ValidationHandler {
    private ParameterProcessor[] queryParameters;
    private ParameterProcessor[] pathParameters;
    private ParameterProcessor[] cookieParameters;
    private ParameterProcessor[] headerParameters;
    private BodyProcessor[] bodyProcessors;
    private Function<RoutingContext, RequestPredicateResult>[] predicates;

    public ValidationHandlerImpl(Map<ParameterLocation, List<ParameterProcessor>> parameterProcessors, List<BodyProcessor> bodyProcessors, List<Function<RoutingContext, RequestPredicateResult>> predicates) {
        ParameterProcessor[] parameterProcessorArray = this.queryParameters = parameterProcessors.get((Object)ParameterLocation.QUERY) == null || parameterProcessors.get((Object)ParameterLocation.QUERY).isEmpty() ? null : parameterProcessors.get((Object)ParameterLocation.QUERY).toArray(new ParameterProcessor[0]);
        if (this.queryParameters != null) {
            Arrays.sort(this.queryParameters);
        }
        ParameterProcessor[] parameterProcessorArray2 = this.pathParameters = parameterProcessors.get((Object)ParameterLocation.PATH) == null || parameterProcessors.get((Object)ParameterLocation.PATH).isEmpty() ? null : parameterProcessors.get((Object)ParameterLocation.PATH).toArray(new ParameterProcessor[0]);
        if (this.pathParameters != null) {
            Arrays.sort(this.pathParameters);
        }
        ParameterProcessor[] parameterProcessorArray3 = this.cookieParameters = parameterProcessors.get((Object)ParameterLocation.COOKIE) == null || parameterProcessors.get((Object)ParameterLocation.COOKIE).isEmpty() ? null : parameterProcessors.get((Object)ParameterLocation.COOKIE).toArray(new ParameterProcessor[0]);
        if (this.cookieParameters != null) {
            Arrays.sort(this.cookieParameters);
        }
        ParameterProcessor[] parameterProcessorArray4 = this.headerParameters = parameterProcessors.get((Object)ParameterLocation.HEADER) == null || parameterProcessors.get((Object)ParameterLocation.HEADER).isEmpty() ? null : parameterProcessors.get((Object)ParameterLocation.HEADER).toArray(new ParameterProcessor[0]);
        if (this.headerParameters != null) {
            Arrays.sort(this.headerParameters);
        }
        this.bodyProcessors = bodyProcessors == null || bodyProcessors.isEmpty() ? null : bodyProcessors.toArray(new BodyProcessor[0]);
        this.predicates = predicates == null || predicates.isEmpty() ? null : predicates.toArray(new Function[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(RoutingContext routingContext) {
        try {
            if (this.predicates != null) {
                this.runPredicates(routingContext);
            }
            RequestParametersImpl requestParameters = new RequestParametersImpl();
            Future resultFut = Future.succeededFuture((Object)requestParameters);
            Future waitingFut = Future.succeededFuture();
            if (this.pathParameters != null) {
                Future<Map<String, RequestParameter>> future = this.validatePathParams(routingContext);
                if (future.isComplete()) {
                    if (!future.succeeded()) {
                        routingContext.fail(400, future.cause());
                        return;
                    }
                    requestParameters.setPathParameters((Map)future.result());
                } else {
                    waitingFut = future.compose(res -> {
                        requestParameters.setPathParameters((Map<String, RequestParameter>)res);
                        return resultFut;
                    });
                }
            }
            if (this.cookieParameters != null) {
                Future<Map<String, RequestParameter>> future = this.validateCookieParams(routingContext);
                if (future.isComplete()) {
                    if (!future.succeeded()) {
                        routingContext.fail(400, future.cause());
                        return;
                    }
                    requestParameters.setCookieParameters((Map)future.result());
                } else {
                    waitingFut = future.compose(res -> {
                        requestParameters.setCookieParameters((Map<String, RequestParameter>)res);
                        return resultFut;
                    });
                }
            }
            if (this.queryParameters != null) {
                Future<Map<String, RequestParameter>> future = this.validateQueryParams(routingContext);
                if (future.isComplete()) {
                    if (!future.succeeded()) {
                        routingContext.fail(400, future.cause());
                        return;
                    }
                    requestParameters.setQueryParameters((Map)future.result());
                } else {
                    waitingFut = future.compose(res -> {
                        requestParameters.setQueryParameters((Map<String, RequestParameter>)res);
                        return resultFut;
                    });
                }
            }
            if (this.headerParameters != null) {
                Future<Map<String, RequestParameter>> future = this.validateHeaderParams(routingContext);
                if (future.isComplete()) {
                    if (!future.succeeded()) {
                        routingContext.fail(400, future.cause());
                        return;
                    }
                    requestParameters.setHeaderParameters((Map)future.result());
                } else {
                    waitingFut = future.compose(res -> {
                        requestParameters.setHeaderParameters((Map<String, RequestParameter>)res);
                        return resultFut;
                    });
                }
            }
            if (this.bodyProcessors != null && routingContext.request().headers().contains("content-type")) {
                Future<RequestParameter> future = this.validateBody(routingContext);
                if (future.isComplete()) {
                    if (!future.succeeded()) {
                        routingContext.fail(400, future.cause());
                        return;
                    }
                    requestParameters.setBody((RequestParameter)future.result());
                } else {
                    waitingFut = future.compose(res -> {
                        requestParameters.setBody((RequestParameter)res);
                        return resultFut;
                    });
                }
            }
            waitingFut.onComplete(ar -> {
                if (ar.failed()) {
                    routingContext.fail(400, ar.cause());
                } else {
                    if (routingContext.data().containsKey("parsedParameters")) {
                        ((RequestParametersImpl)routingContext.get("parsedParameters")).merge(requestParameters);
                    } else {
                        routingContext.put("parsedParameters", (Object)requestParameters);
                        routingContext.put("requestParameters", (Object)requestParameters);
                    }
                    routingContext.next();
                }
            });
            return;
        }
        catch (BadRequestException e) {
            routingContext.fail(400, (Throwable)((Object)e));
        }
    }

    public boolean isBodyRequired() {
        if (this.predicates == null) {
            return false;
        }
        return Arrays.stream(this.predicates).anyMatch(p -> p == RequestPredicate.BODY_REQUIRED);
    }

    private void runPredicates(RoutingContext context) throws BadRequestException {
        for (Function<RoutingContext, RequestPredicateResult> p : this.predicates) {
            RequestPredicateResult res = p.apply(context);
            if (res.succeeded()) continue;
            throw new RequestPredicateException(res.getErrorMessage());
        }
    }

    private Future<Map<String, RequestParameter>> validatePathParams(RoutingContext routingContext) {
        Map<String, List<String>> pathParams = routingContext.pathParams().entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, List<String>>((String)e.getKey(), Collections.singletonList((String)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        return this.processParams(parsedParams, pathParams, this.pathParameters, false);
    }

    private Future<Map<String, RequestParameter>> validateCookieParams(RoutingContext routingContext) {
        HashMap<String, List<String>> cookies = new HashMap<String, List<String>>();
        if (routingContext.request().headers().contains("Cookie")) {
            QueryStringDecoder decoder = new QueryStringDecoder("/?" + routingContext.request().getHeader("Cookie"));
            for (Map.Entry entry : decoder.parameters().entrySet()) {
                cookies.merge(((String)entry.getKey()).trim(), (List)entry.getValue(), (oldValue, newValue) -> {
                    oldValue.addAll(newValue);
                    return oldValue;
                });
            }
        }
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        return this.processParams(parsedParams, cookies, this.cookieParameters, false);
    }

    private Future<Map<String, RequestParameter>> validateQueryParams(RoutingContext routingContext) {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        routingContext.queryParams().forEach(e -> queryParams.computeIfAbsent((String)e.getKey(), k -> new ArrayList()).add((String)e.getValue()));
        return this.processParams(parsedParams, queryParams, this.queryParameters, false);
    }

    private Future<Map<String, RequestParameter>> validateHeaderParams(RoutingContext routingContext) {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        routingContext.request().headers().forEach(e -> headers.computeIfAbsent(((String)e.getKey()).toLowerCase(), k -> new ArrayList()).add((String)e.getValue()));
        return this.processParams(parsedParams, headers, this.headerParameters, true);
    }

    private Future<RequestParameter> validateBody(RoutingContext routingContext) {
        for (BodyProcessor processor : this.bodyProcessors) {
            if (!processor.canProcess(routingContext.parsedHeaders().contentType().value())) continue;
            return processor.process(routingContext);
        }
        throw BodyProcessorException.createMissingMatchingBodyProcessor(routingContext.parsedHeaders().contentType().value());
    }

    private Future<Map<String, RequestParameter>> processParams(Map<String, RequestParameter> parsedParams, Map<String, List<String>> params, ParameterProcessor[] processors, boolean forceLowercase) {
        Future waitingFutureChain = Future.succeededFuture(parsedParams);
        for (ParameterProcessor processor : processors) {
            try {
                Future<RequestParameter> fut = processor.process(params);
                if (fut.isComplete()) {
                    if (fut.succeeded()) {
                        parsedParams.put(forceLowercase ? processor.getName().toLowerCase() : processor.getName(), (RequestParameter)fut.result());
                        continue;
                    }
                    if (!fut.failed()) continue;
                    return Future.failedFuture((Throwable)fut.cause());
                }
                waitingFutureChain = waitingFutureChain.compose(m -> fut.map(rp -> {
                    parsedParams.put(processor.getName(), (RequestParameter)rp);
                    return parsedParams;
                }));
            }
            catch (BadRequestException e) {
                return Future.failedFuture((Throwable)((Object)e));
            }
        }
        return waitingFutureChain;
    }
}

