/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.BadRequestException;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.ParameterLocation;

public class ParameterProcessorException
extends BadRequestException {
    private String parameterName;
    private ParameterLocation location;
    private ParameterProcessorErrorType errorType;

    public ParameterProcessorException(String message, boolean customMessage, String parameterName, ParameterLocation location, ParameterProcessorErrorType errorType, Throwable cause) {
        super(message, customMessage, cause);
        this.parameterName = parameterName;
        this.location = location;
        this.errorType = errorType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public ParameterLocation getLocation() {
        return this.location;
    }

    public ParameterProcessorErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public JsonObject toJson() {
        return super.toJson().put("parameterName", (Object)this.parameterName).put("errorType", (Object)this.errorType.name()).put("location", (Object)this.location.name());
    }

    public static ParameterProcessorException createMissingParameterWhenRequired(String parameterName, ParameterLocation location, String message) {
        return new ParameterProcessorException((String)(message != null ? message : "Missing parameter " + parameterName + " in " + String.valueOf((Object)location)), message != null, parameterName, location, ParameterProcessorErrorType.MISSING_PARAMETER_WHEN_REQUIRED_ERROR, null);
    }

    public static ParameterProcessorException createParsingError(String parameterName, ParameterLocation location, MalformedValueException cause, String message) {
        return new ParameterProcessorException(message != null ? message : String.format("Parsing error for parameter %s in location %s: %s", new Object[]{parameterName, location, cause.getMessage()}), message != null, parameterName, location, ParameterProcessorErrorType.PARSING_ERROR, (Throwable)((Object)cause));
    }

    public static ParameterProcessorException createValidationError(String parameterName, ParameterLocation location, Throwable cause, String message) {
        return new ParameterProcessorException(message != null ? message : String.format("Validation error for parameter %s in location %s: %s", new Object[]{parameterName, location, cause.getMessage()}), message != null, parameterName, location, ParameterProcessorErrorType.VALIDATION_ERROR, cause);
    }

    @VertxGen
    public static enum ParameterProcessorErrorType {
        MISSING_PARAMETER_WHEN_REQUIRED_ERROR,
        PARSING_ERROR,
        VALIDATION_ERROR;

    }
}

