/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl.parser;

import io.vertx.ext.web.validation.impl.parser.ValueParser;
import java.util.List;
import java.util.stream.Stream;

public abstract class TupleParser {
    private final ValueParser<String>[] itemsParser;
    private final ValueParser<String> additionalItemsParser;

    public TupleParser(List<ValueParser<String>> itemsParser, ValueParser<String> additionalItemsParser) {
        this.itemsParser = itemsParser.toArray(new ValueParser[0]);
        this.additionalItemsParser = additionalItemsParser != null ? additionalItemsParser : ValueParser.NOOP_PARSER;
    }

    protected Stream<Object> parseItem(int i, String serialized) {
        if (i < this.itemsParser.length) {
            return Stream.of(this.parseValue(serialized, this.itemsParser[i]));
        }
        if (this.additionalItemsParser != null) {
            return Stream.of(this.parseValue(serialized, this.additionalItemsParser));
        }
        return null;
    }

    private Object parseValue(String v, ValueParser<String> parser) {
        return this.mustNullateValue(v, parser) ? null : parser.parse(v);
    }

    protected abstract boolean mustNullateValue(String var1, ValueParser<String> var2);
}

