/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.RequestParameter;
import java.util.Objects;

public class RequestParameterImpl
implements RequestParameter {
    private Object value;

    public RequestParameterImpl(Object value) {
        this.value = value;
    }

    public RequestParameterImpl() {
        this(null);
    }

    @Override
    public @Nullable String getString() {
        return this.isString() ? (String)this.value : null;
    }

    @Override
    public boolean isString() {
        return !this.isNull() && this.value instanceof String;
    }

    @Override
    public @Nullable Integer getInteger() {
        return this.isNumber() ? Integer.valueOf(((Number)this.value).intValue()) : null;
    }

    @Override
    public @Nullable Long getLong() {
        return this.isNumber() ? Long.valueOf(((Number)this.value).longValue()) : null;
    }

    @Override
    public @Nullable Float getFloat() {
        return this.isNumber() ? Float.valueOf(((Number)this.value).floatValue()) : null;
    }

    @Override
    public @Nullable Double getDouble() {
        return this.isNumber() ? Double.valueOf(((Number)this.value).doubleValue()) : null;
    }

    @Override
    public boolean isNumber() {
        return !this.isNull() && this.value instanceof Number;
    }

    @Override
    public @Nullable Boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.value : null;
    }

    @Override
    public boolean isBoolean() {
        return !this.isNull() && this.value instanceof Boolean;
    }

    @Override
    public @Nullable JsonObject getJsonObject() {
        return this.isJsonObject() ? (JsonObject)this.value : null;
    }

    @Override
    public boolean isJsonObject() {
        return !this.isNull() && this.value instanceof JsonObject;
    }

    @Override
    public @Nullable JsonArray getJsonArray() {
        return this.isJsonArray() ? (JsonArray)this.value : null;
    }

    @Override
    public boolean isJsonArray() {
        return !this.isNull() && this.value instanceof JsonArray;
    }

    @Override
    public @Nullable Buffer getBuffer() {
        return this.isBuffer() ? (Buffer)this.value : null;
    }

    @Override
    public boolean isBuffer() {
        return !this.isNull() && this.value instanceof Buffer;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isEmpty() {
        return this.isNull() || this.isString() && this.getString().isEmpty() || this.isJsonObject() && this.getJsonObject().isEmpty() || this.isJsonArray() && this.getJsonArray().isEmpty() || this.isBuffer() && this.getBuffer().length() == 0;
    }

    @Override
    public Object get() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestParameterImpl that = (RequestParameterImpl)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

