/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.builder;

import io.vertx.ext.web.validation.builder.BodyProcessorFactory;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.body.FormBodyProcessorImpl;
import io.vertx.ext.web.validation.impl.body.JsonBodyProcessorImpl;
import io.vertx.ext.web.validation.impl.body.TextPlainBodyProcessorImpl;
import io.vertx.ext.web.validation.impl.validator.SchemaValidator;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.common.dsl.ObjectSchemaBuilder;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;

public interface Bodies {
    public static BodyProcessorFactory json(SchemaBuilder schemaBuilder) {
        return parser -> new JsonBodyProcessorImpl(new SchemaValidator(schemaBuilder.build(parser)));
    }

    public static BodyProcessorFactory textPlain(StringSchemaBuilder schemaBuilder) {
        return parser -> new TextPlainBodyProcessorImpl(new SchemaValidator(schemaBuilder.build(parser)));
    }

    public static BodyProcessorFactory formUrlEncoded(ObjectSchemaBuilder schemaBuilder) {
        return parser -> {
            Schema s = schemaBuilder.build(parser);
            Object jsonSchema = s.getJson();
            return new FormBodyProcessorImpl(ValueParserInferenceUtils.infeerPropertiesFormValueParserForObjectSchema(jsonSchema), ValueParserInferenceUtils.infeerPatternPropertiesFormValueParserForObjectSchema(jsonSchema), ValueParserInferenceUtils.infeerAdditionalPropertiesFormValueParserForObjectSchema(jsonSchema), "application/x-www-form-urlencoded", new SchemaValidator(s));
        };
    }

    public static BodyProcessorFactory multipartFormData(ObjectSchemaBuilder schemaBuilder) {
        return parser -> {
            Schema s = schemaBuilder.build(parser);
            Object jsonSchema = s.getJson();
            return new FormBodyProcessorImpl(ValueParserInferenceUtils.infeerPropertiesFormValueParserForObjectSchema(jsonSchema), ValueParserInferenceUtils.infeerPatternPropertiesFormValueParserForObjectSchema(jsonSchema), ValueParserInferenceUtils.infeerAdditionalPropertiesFormValueParserForObjectSchema(jsonSchema), "multipart/form-data", new SchemaValidator(s));
        };
    }
}

