/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.rythm.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.ext.web.common.template.CachedTemplate;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.rythm.RythmTemplateEngine;
import java.util.Locale;
import java.util.Map;
import org.rythmengine.RythmEngine;

public class RythmTemplateEngineImpl
extends CachingTemplateEngine<String>
implements RythmTemplateEngine {
    private final FileSystem fileSystem;
    private final RythmEngine engine;

    public RythmTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.fileSystem = vertx.fileSystem();
        this.engine = new RythmEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Buffer> render(Map<String, Object> context, String templateFile) {
        try {
            String src = this.adjustLocation(templateFile);
            CachedTemplate template = this.getTemplate(src);
            if (template == null) {
                RythmTemplateEngineImpl rythmTemplateEngineImpl = this;
                synchronized (rythmTemplateEngineImpl) {
                    template = new CachedTemplate((Object)this.fileSystem.readFileBlocking(src).toString());
                }
                this.putTemplate(src, template);
            }
            if (context.containsKey("lang")) {
                this.engine.prepare(Locale.forLanguageTag((String)context.get("lang")));
            } else {
                this.engine.prepare(Locale.getDefault());
            }
            return Future.succeededFuture((Object)Buffer.buffer((String)this.engine.renderString((String)template.template(), new Object[]{context})));
        }
        catch (Exception ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    public <T> T unwrap() throws ClassCastException {
        return (T)this.engine;
    }
}

