/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.pebble.impl;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.pebble.PebbleTemplateEngine;
import io.vertx.ext.web.templ.pebble.impl.PebbleVertxLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class PebbleTemplateEngineImpl
extends CachingTemplateEngine<PebbleTemplate>
implements PebbleTemplateEngine {
    private final PebbleEngine pebbleEngine;

    public PebbleTemplateEngineImpl(Vertx vertx) {
        this(new PebbleEngine.Builder().loader((Loader)new PebbleVertxLoader(vertx)).cacheActive(false).build());
    }

    public PebbleTemplateEngineImpl(PebbleEngine engine) {
        super("peb", 10000);
        this.pebbleEngine = engine;
    }

    @Override
    public PebbleTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public PebbleTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            PebbleTemplate template;
            PebbleTemplate pebbleTemplate = template = this.isCachingEnabled() ? (PebbleTemplate)this.cache.get((Object)templateFile) : null;
            if (template == null) {
                String loc = this.adjustLocation(templateFile);
                template = this.pebbleEngine.getTemplate(loc);
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFile, (Object)template);
                }
            }
            String lang = (String)context.get("lang");
            StringWriter stringWriter = new StringWriter();
            template.evaluate((Writer)stringWriter, context, lang == null ? Locale.getDefault() : Locale.forLanguageTag(lang));
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)stringWriter.toString())));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

