/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.Loader;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;

class PebbleVertxLoader
implements Loader<String> {
    private final Vertx vertx;
    private String charset = Charset.defaultCharset().toString();

    public PebbleVertxLoader(Vertx vertx) {
        this.vertx = vertx;
    }

    public Reader getReader(String s) throws LoaderException {
        try {
            final char[] buffer = this.vertx.fileSystem().readFileBlocking(s).toString(this.charset).toCharArray();
            final int[] pos = new int[]{0};
            return new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    if (pos[0] == buffer.length) {
                        return -1;
                    }
                    int end = Math.min(buffer.length, pos[0] + len);
                    System.arraycopy(buffer, pos[0], cbuf, off, end);
                    int read = end - pos[0];
                    pos[0] = end;
                    return read;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        catch (RuntimeException e) {
            throw new LoaderException((Throwable)e, e.getMessage());
        }
    }

    public void setCharset(String s) {
        this.charset = s;
    }

    public void setPrefix(String s) {
    }

    public void setSuffix(String s) {
    }

    public String resolveRelativePath(String s, String anchorPath) {
        File resolved = new File(new File(anchorPath).getParentFile(), s);
        return resolved.getPath();
    }

    public String createCacheKey(String s) {
        return s;
    }
}

