/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.jte.impl;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.Utf8ByteOutput;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.templ.jte.JteTemplateEngine;
import io.vertx.ext.web.templ.jte.impl.JteBufferUtil;
import io.vertx.ext.web.templ.jte.impl.VertxDirectoryCodeResolver;
import java.util.Map;

public class JteTemplateEngineImpl
implements JteTemplateEngine {
    private final TemplateEngine templateEngine;
    private final VertxDirectoryCodeResolver codeResolver;

    public JteTemplateEngineImpl(TemplateEngine engine) {
        this.templateEngine = engine;
        this.codeResolver = null;
    }

    public JteTemplateEngineImpl(Vertx vertx, String templateRootDirectory) {
        this.codeResolver = new VertxDirectoryCodeResolver(vertx, templateRootDirectory);
        this.templateEngine = TemplateEngine.create((CodeResolver)this.codeResolver, (ContentType)ContentType.Html);
        this.templateEngine.setBinaryStaticContent(true);
    }

    public JteTemplateEngineImpl() {
        this.codeResolver = null;
        this.templateEngine = TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
    }

    public Future<Buffer> render(Map<String, Object> context, String templateFile) {
        try {
            Utf8ByteOutput output = new Utf8ByteOutput();
            this.templateEngine.render(templateFile, context, (TemplateOutput)output);
            return Future.succeededFuture((Object)JteBufferUtil.toBuffer(output));
        }
        catch (RuntimeException ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    public void clearCache() {
    }

    @Override
    public TemplateEngine unwrap() throws ClassCastException {
        return this.templateEngine;
    }
}

