/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.jte.impl;

import gg.jte.CodeResolver;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;

public class VertxDirectoryCodeResolver
implements CodeResolver {
    private final FileSystem fs;
    private final Path templateRootDirectory;

    public VertxDirectoryCodeResolver(Vertx vertx, String templateRootDirectory) {
        this.fs = vertx.fileSystem();
        this.templateRootDirectory = Paths.get(templateRootDirectory, new String[0]);
    }

    public String resolve(String name) {
        return this.fs.readFileBlocking(this.templateRootDirectory.resolve(name).toString()).toString();
    }

    public long getLastModified(String name) {
        return this.fs.propsBlocking(this.templateRootDirectory.resolve(name).toString()).lastModifiedTime();
    }
}

