/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.HandlebarsTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import io.vertx.ext.web.templ.impl.JsonArrayValueResolver;
import io.vertx.ext.web.templ.impl.JsonObjectValueResolver;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;

public class HandlebarsTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements HandlebarsTemplateEngine {
    private final Handlebars handlebars;
    private final Loader loader = new Loader();
    private final ValueResolver[] DEFAULT_VERTX_RESOLVERS = new ValueResolver[]{JsonArrayValueResolver.INSTANCE, JsonObjectValueResolver.INSTANCE};
    private ValueResolver[] resolvers = (ValueResolver[])ArrayUtils.addAll((Object[])this.DEFAULT_VERTX_RESOLVERS, (Object[])ValueResolver.VALUE_RESOLVERS);

    public HandlebarsTemplateEngineImpl() {
        super("hbs", 10000);
        this.handlebars = new Handlebars((TemplateLoader)this.loader);
    }

    @Override
    public HandlebarsTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public HandlebarsTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            Template template = (Template)this.cache.get((Object)templateFileName);
            if (template == null) {
                HandlebarsTemplateEngineImpl handlebarsTemplateEngineImpl = this;
                synchronized (handlebarsTemplateEngineImpl) {
                    this.loader.setVertx(context.vertx());
                    template = this.handlebars.compile(templateFileName);
                    this.cache.put((Object)templateFileName, (Object)template);
                }
            }
            Context engineContext = Context.newBuilder((Object)context.data()).resolver(this.getResolvers()).build();
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)template.apply(engineContext))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    @Override
    public ValueResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public HandlebarsTemplateEngine setResolvers(ValueResolver ... resolvers) {
        this.resolvers = resolvers;
        return this;
    }

    private class Loader
    implements TemplateLoader {
        private Vertx vertx;

        private Loader() {
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        public TemplateSource sourceAt(String location) throws IOException {
            final String loc = HandlebarsTemplateEngineImpl.this.adjustLocation(location);
            final String templ = Utils.readFileToString((Vertx)this.vertx, (String)loc);
            if (templ == null) {
                throw new IllegalArgumentException("Cannot find resource " + loc);
            }
            final long lastMod = System.currentTimeMillis();
            return new TemplateSource(){

                public String content() throws IOException {
                    return templ;
                }

                public String filename() {
                    return loc;
                }

                public long lastModified() {
                    return lastMod;
                }
            };
        }

        public String resolve(String location) {
            return location;
        }

        public String getPrefix() {
            return null;
        }

        public String getSuffix() {
            return HandlebarsTemplateEngineImpl.this.extension;
        }

        public void setPrefix(String prefix) {
        }

        public void setSuffix(String suffix) {
            HandlebarsTemplateEngineImpl.this.extension = suffix;
        }
    }
}

