/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.redis.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import io.vertx.ext.web.sstore.redis.RedisSessionStore;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import java.util.Objects;

public class RedisSessionStoreImpl
implements RedisSessionStore {
    private Redis redis;
    private VertxContextPRNG random;
    private long retryTimeout;
    private ContextInternal ctx;

    public SessionStore init(Vertx vertx, JsonObject options) {
        Objects.requireNonNull(options, "options are required");
        long timeout = options.getLong("retryTimeout", Long.valueOf(2000L));
        Redis redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(options));
        return this.init(vertx, timeout, redis);
    }

    public SessionStore init(Vertx vertx, long retryTimeout, Redis redis) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.ctx = (ContextInternal)vertx.getOrCreateContext();
        this.retryTimeout = retryTimeout;
        this.redis = Objects.requireNonNull(redis, "redis is required");
        return this;
    }

    public long retryTimeout() {
        return this.retryTimeout;
    }

    public Session createSession(long timeout) {
        return this.createSession(timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    public Future<@Nullable Session> get(String id) {
        return this.redis.send(Request.cmd((Command)Command.GET).arg(id)).compose(response -> {
            if (response != null) {
                SharedDataSessionImpl session = new SharedDataSessionImpl(this.random);
                session.readFromBuffer(0, response.toBuffer());
                return this.redis.send(Request.cmd((Command)Command.PEXPIRE).arg(id).arg(session.timeout())).map((Object)session);
            }
            return this.ctx.succeededFuture();
        });
    }

    public Future<Void> delete(String id) {
        return this.redis.send(Request.cmd((Command)Command.DEL).arg(id)).mapEmpty();
    }

    public Future<Void> put(Session session) {
        return this.redis.send(Request.cmd((Command)Command.GET).arg(session.id())).compose(response -> {
            AbstractSession newSession = (AbstractSession)session;
            if (response != null) {
                SharedDataSessionImpl oldSession = new SharedDataSessionImpl(this.random);
                oldSession.readFromBuffer(0, response.toBuffer());
                if (oldSession.version() != newSession.version()) {
                    return Future.failedFuture((String)"Session version mismatch");
                }
            }
            newSession.incrementVersion();
            return this.writeSession((Session)newSession);
        });
    }

    private Future<Void> writeSession(Session session) {
        Buffer buffer = Buffer.buffer();
        SharedDataSessionImpl sessionImpl = (SharedDataSessionImpl)session;
        sessionImpl.writeToBuffer(buffer);
        Request rq = Request.cmd((Command)Command.SET).arg(session.id()).arg(buffer).arg("PX").arg(session.timeout());
        return this.redis.send(rq).mapEmpty();
    }

    public Future<Void> clear() {
        return this.redis.send(Request.cmd((Command)Command.FLUSHDB)).mapEmpty();
    }

    public Future<Integer> size() {
        return this.redis.send(Request.cmd((Command)Command.DBSIZE)).compose(response -> {
            if (response == null) {
                return this.ctx.succeededFuture((Object)-1);
            }
            Long lngCount = response.toLong();
            int count = lngCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : lngCount.intValue();
            return this.ctx.succeededFuture((Object)count);
        });
    }

    public void close() {
        this.redis.close();
    }
}

