/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.cookie.CookieSessionStore;
import io.vertx.ext.web.sstore.cookie.impl.CookieSession;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CookieSessionStoreImpl
implements CookieSessionStore {
    private Mac mac;
    private VertxContextPRNG random;
    private ContextInternal ctx;

    public CookieSessionStoreImpl() {
    }

    public CookieSessionStoreImpl(Vertx vertx, String secret) {
        this.init(vertx, new JsonObject().put("secret", (Object)secret));
    }

    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.ctx = (ContextInternal)vertx.getOrCreateContext();
        try {
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(new SecretKeySpec(options.getString("secret").getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public long retryTimeout() {
        return -1L;
    }

    public Session createSession(long timeout) {
        return new CookieSession(this.mac, this.random, timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new CookieSession(this.mac, this.random, timeout, length);
    }

    public Future<@Nullable Session> get(String cookieValue) {
        try {
            CookieSession session = new CookieSession(this.mac, this.random).setValue(cookieValue);
            if (session == null) {
                return this.ctx.succeededFuture();
            }
            long now = System.currentTimeMillis();
            if (now - session.lastAccessed() > session.timeout()) {
                return this.ctx.succeededFuture();
            }
            return this.ctx.succeededFuture((Object)session);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    public Future<Void> delete(String id) {
        return this.ctx.succeededFuture();
    }

    public Future<Void> put(Session session) {
        CookieSession cookieSession = (CookieSession)session;
        if (cookieSession.oldVersion() != -1 && cookieSession.oldVersion() != cookieSession.version()) {
            return Future.failedFuture((String)"Session version mismatch");
        }
        cookieSession.incrementVersion();
        return this.ctx.succeededFuture();
    }

    public Future<Void> clear() {
        return this.ctx.succeededFuture();
    }

    public Future<Integer> size() {
        return this.ctx.succeededFuture((Object)0);
    }

    public void close() {
    }
}

