/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.sstore.AbstractSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;

public class CookieSession
extends AbstractSession {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Mac mac;
    private int oldVersion = 0;
    private int oldCrc = 0;

    public CookieSession(Mac mac, VertxContextPRNG prng, long timeout, int length) {
        super(prng, timeout, length);
        this.mac = mac;
    }

    public CookieSession(Mac mac, VertxContextPRNG prng) {
        super(prng);
        this.mac = mac;
    }

    public String value() {
        Buffer buff = Buffer.buffer();
        byte[] bytes = this.id().getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        this.writeDataToBuffer(buff);
        String b64 = Codec.base64UrlEncode((byte[])buff.getBytes());
        String signature = Codec.base64UrlEncode((byte[])this.mac.doFinal(b64.getBytes(StandardCharsets.US_ASCII)));
        return b64 + "." + signature;
    }

    public boolean isRegenerated() {
        if (!super.isRegenerated()) {
            return this.oldCrc != this.checksum();
        }
        return true;
    }

    protected CookieSession setValue(String payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        String[] tokens = payload.split("\\.");
        if (tokens.length != 2) {
            return null;
        }
        String signature = Codec.base64UrlEncode((byte[])this.mac.doFinal(tokens[0].getBytes(StandardCharsets.US_ASCII)));
        if (!signature.equals(tokens[1])) {
            throw new RuntimeException("Session data was Tampered!");
        }
        Buffer buffer = Buffer.buffer((byte[])Codec.base64UrlDecode((String)tokens[0]));
        int pos = 0;
        int len = buffer.getInt(0);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.setId(new String(bytes, UTF8));
        this.setTimeout(buffer.getLong(pos += len));
        this.setLastAccessed(buffer.getLong(pos += 8));
        this.setVersion(buffer.getInt(pos += 8));
        this.readDataFromBuffer(pos += 4, buffer);
        this.oldVersion = this.version();
        this.oldCrc = this.crc();
        return this;
    }

    int oldVersion() {
        return this.oldVersion;
    }
}

