/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.sstore.AbstractSession;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;

public class CookieSession
extends AbstractSession {
    private final Mac mac;
    private int oldVersion = 0;
    private int oldCrc = 0;

    public CookieSession(Mac mac, VertxContextPRNG prng, long timeout, int length) {
        super(prng, timeout, length);
        this.mac = mac;
    }

    public CookieSession(Mac mac, VertxContextPRNG prng) {
        super(prng);
        this.mac = mac;
    }

    public String value() {
        Buffer payload = new JsonObject().put("id", (Object)this.id()).put("timeout", (Object)this.timeout()).put("lastAccessed", (Object)this.lastAccessed()).put("version", (Object)this.version()).put("data", (Object)this.data()).toBuffer();
        String b64 = Codec.base64UrlEncode((byte[])payload.getBytes());
        String signature = Codec.base64UrlEncode((byte[])this.mac.doFinal(b64.getBytes(StandardCharsets.US_ASCII)));
        return b64 + "." + signature;
    }

    public boolean isRegenerated() {
        if (!super.isRegenerated()) {
            return this.oldCrc != this.checksum();
        }
        return true;
    }

    protected CookieSession setValue(String payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        String[] tokens = payload.split("\\.");
        if (tokens.length != 2) {
            return null;
        }
        String signature = Codec.base64UrlEncode((byte[])this.mac.doFinal(tokens[0].getBytes(StandardCharsets.US_ASCII)));
        if (!signature.equals(tokens[1])) {
            throw new RuntimeException("Session data was Tampered!");
        }
        JsonObject decoded = new JsonObject(Buffer.buffer((byte[])Codec.base64UrlDecode((String)tokens[0])));
        this.setId(decoded.getString("id"));
        this.setTimeout(decoded.getLong("timeout"));
        this.setLastAccessed(decoded.getLong("lastAccessed"));
        this.setVersion(decoded.getInteger("version"));
        this.setData(decoded.getJsonObject("data"));
        this.oldVersion = this.version();
        this.oldCrc = this.crc();
        return this;
    }

    int oldVersion() {
        return this.oldVersion;
    }
}

