/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.instrumentation.impl;

import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class ToCompletionStage<T>
extends SimplePerformantInstrumentation {
    private final Class<T> targetType;
    private final Function<T, CompletionStage<?>> converter;

    public ToCompletionStage(Class<T> targetType, Function<T, CompletionStage<?>> converter) {
        this.targetType = Objects.requireNonNull(targetType, "targetType is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (parameters.isTrivialDataFetcher()) {
            return dataFetcher;
        }
        if (dataFetcher instanceof InstrumentedDataFetcher) {
            return dataFetcher;
        }
        parameters.getEnvironment().getGraphQlContext().put(InstrumentedDataFetcher.class, dataFetcher);
        return new InstrumentedDataFetcher<T>(this.targetType, this.converter, dataFetcher);
    }

    private static class InstrumentedDataFetcher<U>
    implements DataFetcher<Object> {
        final Class<U> targetType;
        final Function<U, CompletionStage<?>> converter;
        final DataFetcher<?> originalDataFetcher;

        InstrumentedDataFetcher(Class<U> targetType, Function<U, CompletionStage<?>> converter, DataFetcher<?> originalDataFetcher) {
            this.targetType = targetType;
            this.converter = converter;
            this.originalDataFetcher = originalDataFetcher;
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            Object o = this.originalDataFetcher.get(environment);
            if (this.targetType.isInstance(o)) {
                return this.converter.apply(this.targetType.cast(o));
            }
            return o;
        }
    }
}

