/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.handler.graphql.GraphiQLHandler;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class GraphiQLHandlerImpl
implements GraphiQLHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphiQLHandlerImpl.class);
    private static final String WEBROOT = "io/vertx/ext/web/handler/graphiql";
    private static final Function<RoutingContext, MultiMap> DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY = rc -> null;
    private final GraphiQLHandlerOptions options;
    private final StaticHandler staticHandler;
    private Function<RoutingContext, MultiMap> graphiQLRequestHeadersFactory = DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY;

    public GraphiQLHandlerImpl(GraphiQLHandlerOptions options) {
        Objects.requireNonNull(options, "options");
        this.options = options;
        this.staticHandler = options.isEnabled() ? StaticHandler.create((String)WEBROOT).setCachingEnabled(true).setMaxAgeSeconds(TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS)) : null;
    }

    @Override
    public GraphiQLHandler graphiQLRequestHeaders(Function<RoutingContext, MultiMap> factory) {
        this.graphiQLRequestHeadersFactory = factory != null ? factory : DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY;
        return this;
    }

    public void handle(RoutingContext rc) {
        if (!this.options.isEnabled()) {
            rc.next();
            return;
        }
        String filename = Utils.pathOffset((String)rc.normalizedPath(), (RoutingContext)rc);
        if (filename.isEmpty()) {
            rc.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)rc.currentRoute().getPath()).end();
            return;
        }
        if ("/".equals(filename) || "/index.html".equals(filename)) {
            String resource = rc.vertx().fileSystem().readFileBlocking("io/vertx/ext/web/handler/graphiql/index.html").toString(StandardCharsets.UTF_8).replace("__VERTX_GRAPHIQL_CONFIG__", this.replacement(rc));
            rc.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html;charset=utf8").end(resource);
        } else {
            this.staticHandler.handle((Object)rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replacement(RoutingContext rc) {
        Function<RoutingContext, MultiMap> rh;
        JsonObject json = new JsonObject();
        json.put("httpEnabled", (Object)this.options.isHttpEnabled());
        if (this.options.getGraphQLUri() != null) {
            json.put("graphQLUri", (Object)this.options.getGraphQLUri());
        }
        json.put("graphQLWSEnabled", (Object)this.options.isGraphQLWSEnabled());
        if (this.options.getGraphQLWSUri() != null) {
            json.put("graphQLWSUri", (Object)this.options.getGraphQLWSUri());
        }
        if (this.options.getWsConnectionParams() != null) {
            json.put("wsConnectionParams", (Object)this.options.getWsConnectionParams());
        }
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        Map<String, String> fixedHeaders = this.options.getHeaders();
        if (fixedHeaders != null) {
            fixedHeaders.forEach((arg_0, arg_1) -> ((MultiMap)headers).add(arg_0, arg_1));
        }
        GraphiQLHandlerImpl graphiQLHandlerImpl = this;
        synchronized (graphiQLHandlerImpl) {
            rh = this.graphiQLRequestHeadersFactory;
        }
        MultiMap dynamicHeaders = rh.apply(rc);
        if (dynamicHeaders != null) {
            headers.addAll(dynamicHeaders);
        }
        if (!headers.isEmpty()) {
            JsonObject headersJson = new JsonObject();
            headers.forEach(header -> headersJson.put((String)header.getKey(), header.getValue()));
            json.put("headers", (Object)headersJson);
        }
        if (this.options.getQuery() != null) {
            json.put("query", (Object)this.options.getQuery());
        }
        if (this.options.getVariables() != null) {
            json.put("parameters", (Object)this.options.getVariables());
        }
        return json.encode();
    }
}

