/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

public class VertxDataFetcher<T>
implements DataFetcher<CompletionStage<T>> {
    private final BiConsumer<DataFetchingEnvironment, Future<T>> dataFetcher;

    public VertxDataFetcher(BiConsumer<DataFetchingEnvironment, Future<T>> dataFetcher) {
        this.dataFetcher = dataFetcher;
    }

    public CompletionStage<T> get(DataFetchingEnvironment environment) throws Exception {
        CompletableFuture cf = new CompletableFuture();
        Future future = Future.future();
        future.setHandler(ar -> {
            if (ar.succeeded()) {
                cf.complete(ar.result());
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        this.dataFetcher.accept(environment, future);
        return cf;
    }
}

