/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.uritemplate.UriTemplate;

@VertxGen
public interface WebClient {
    public static WebClient create(Vertx vertx) {
        WebClientOptions options = new WebClientOptions();
        return WebClient.create(vertx, options);
    }

    public static WebClient create(Vertx vertx, WebClientOptions options) {
        return new WebClientBase((HttpClient)vertx.createHttpClient((HttpClientOptions)options), options);
    }

    public static WebClient create(Vertx vertx, WebClientOptions options, PoolOptions poolOptions) {
        return new WebClientBase((HttpClient)vertx.createHttpClient((HttpClientOptions)options, poolOptions), options);
    }

    public static WebClient wrap(HttpClient httpClient) {
        return WebClient.wrap(httpClient, new WebClientOptions());
    }

    public static WebClient wrap(HttpClient httpClient, WebClientOptions options) {
        WebClientOptions actualOptions = new WebClientOptions(((HttpClientInternal)httpClient).options());
        actualOptions.init(options);
        return new WebClientBase(httpClient, actualOptions);
    }

    default public HttpRequest<Buffer> request(HttpMethod method, int port, String host, String requestURI) {
        return this.request(method, null, port, host, requestURI);
    }

    default public HttpRequest<Buffer> request(HttpMethod method, int port, String host, UriTemplate requestURI) {
        return this.request(method, null, port, host, requestURI);
    }

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, int var3, String var4, String var5);

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, int var3, String var4, UriTemplate var5);

    default public HttpRequest<Buffer> request(HttpMethod method, String host, String requestURI) {
        return this.request(method, null, host, requestURI);
    }

    default public HttpRequest<Buffer> request(HttpMethod method, String host, UriTemplate requestURI) {
        return this.request(method, null, host, requestURI);
    }

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, String var3, String var4);

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, String var3, UriTemplate var4);

    default public HttpRequest<Buffer> request(HttpMethod method, String requestURI) {
        return this.request(method, (SocketAddress)null, requestURI);
    }

    default public HttpRequest<Buffer> request(HttpMethod method, UriTemplate requestURI) {
        return this.request(method, (SocketAddress)null, requestURI);
    }

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, String var3);

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, UriTemplate var3);

    default public HttpRequest<Buffer> request(HttpMethod method, RequestOptions options) {
        return this.request(method, null, options);
    }

    public HttpRequest<Buffer> request(HttpMethod var1, SocketAddress var2, RequestOptions var3);

    default public HttpRequest<Buffer> requestAbs(HttpMethod method, String absoluteURI) {
        return this.requestAbs(method, null, absoluteURI);
    }

    default public HttpRequest<Buffer> requestAbs(HttpMethod method, UriTemplate absoluteURI) {
        return this.requestAbs(method, null, absoluteURI);
    }

    public HttpRequest<Buffer> requestAbs(HttpMethod var1, SocketAddress var2, String var3);

    public HttpRequest<Buffer> requestAbs(HttpMethod var1, SocketAddress var2, UriTemplate var3);

    default public HttpRequest<Buffer> get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    default public HttpRequest<Buffer> get(UriTemplate requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    default public HttpRequest<Buffer> get(int port, String host, String requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    default public HttpRequest<Buffer> get(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    default public HttpRequest<Buffer> get(String host, String requestURI) {
        return this.request(HttpMethod.GET, host, requestURI);
    }

    default public HttpRequest<Buffer> get(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.GET, host, requestURI);
    }

    default public HttpRequest<Buffer> getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    default public HttpRequest<Buffer> getAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    default public HttpRequest<Buffer> post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    default public HttpRequest<Buffer> post(UriTemplate requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    default public HttpRequest<Buffer> post(int port, String host, String requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    default public HttpRequest<Buffer> post(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    default public HttpRequest<Buffer> post(String host, String requestURI) {
        return this.request(HttpMethod.POST, host, requestURI);
    }

    default public HttpRequest<Buffer> post(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.POST, host, requestURI);
    }

    default public HttpRequest<Buffer> postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    default public HttpRequest<Buffer> postAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    default public HttpRequest<Buffer> put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    default public HttpRequest<Buffer> put(UriTemplate requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    default public HttpRequest<Buffer> put(int port, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    default public HttpRequest<Buffer> put(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    default public HttpRequest<Buffer> put(String host, String requestURI) {
        return this.request(HttpMethod.PUT, host, requestURI);
    }

    default public HttpRequest<Buffer> put(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.PUT, host, requestURI);
    }

    default public HttpRequest<Buffer> putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    default public HttpRequest<Buffer> putAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    default public HttpRequest<Buffer> delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    default public HttpRequest<Buffer> delete(UriTemplate requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    default public HttpRequest<Buffer> delete(int port, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    default public HttpRequest<Buffer> delete(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    default public HttpRequest<Buffer> delete(String host, String requestURI) {
        return this.request(HttpMethod.DELETE, host, requestURI);
    }

    default public HttpRequest<Buffer> delete(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.DELETE, host, requestURI);
    }

    default public HttpRequest<Buffer> deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    default public HttpRequest<Buffer> deleteAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    default public HttpRequest<Buffer> patch(String requestURI) {
        return this.request(HttpMethod.PATCH, requestURI);
    }

    default public HttpRequest<Buffer> patch(UriTemplate requestURI) {
        return this.request(HttpMethod.PATCH, requestURI);
    }

    default public HttpRequest<Buffer> patch(int port, String host, String requestURI) {
        return this.request(HttpMethod.PATCH, port, host, requestURI);
    }

    default public HttpRequest<Buffer> patch(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.PATCH, port, host, requestURI);
    }

    default public HttpRequest<Buffer> patch(String host, String requestURI) {
        return this.request(HttpMethod.PATCH, host, requestURI);
    }

    default public HttpRequest<Buffer> patch(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.PATCH, host, requestURI);
    }

    default public HttpRequest<Buffer> patchAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PATCH, absoluteURI);
    }

    default public HttpRequest<Buffer> patchAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.PATCH, absoluteURI);
    }

    default public HttpRequest<Buffer> head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    default public HttpRequest<Buffer> head(UriTemplate requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    default public HttpRequest<Buffer> head(int port, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    default public HttpRequest<Buffer> head(int port, String host, UriTemplate requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    default public HttpRequest<Buffer> head(String host, String requestURI) {
        return this.request(HttpMethod.HEAD, host, requestURI);
    }

    default public HttpRequest<Buffer> head(String host, UriTemplate requestURI) {
        return this.request(HttpMethod.HEAD, host, requestURI);
    }

    default public HttpRequest<Buffer> headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    default public HttpRequest<Buffer> headAbs(UriTemplate absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @GenIgnore
    public WebClient addInterceptor(Handler<HttpContext<?>> var1);

    default public Future<Boolean> updateSSLOptions(ClientSSLOptions options) {
        return this.updateSSLOptions(options, false);
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions var1, boolean var2);

    public void close();
}

