/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.CachingWebClientOptions;
import java.util.LinkedHashSet;
import java.util.Map;

public class CachingWebClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, CachingWebClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enableVaryCaching": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnableVaryCaching((Boolean)member.getValue());
                    break;
                }
                case "cachedStatusCodes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Integer> list = new LinkedHashSet<Integer>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).intValue());
                        }
                    });
                    obj.setCachedStatusCodes(list);
                    break;
                }
                case "cachedMethods": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Integer> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Integer)new HttpMethod((String)item));
                        }
                    });
                    obj.setCachedMethods(list);
                    break;
                }
            }
        }
    }

    static void toJson(CachingWebClientOptions obj, JsonObject json) {
        CachingWebClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CachingWebClientOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCachedStatusCodes() != null) {
            array = new JsonArray();
            obj.getCachedStatusCodes().forEach(item -> array.add(item));
            json.put("cachedStatusCodes", array);
        }
        if (obj.getCachedMethods() != null) {
            array = new JsonArray();
            obj.getCachedMethods().forEach(item -> array.add((Object)item.toJson()));
            json.put("cachedMethods", array);
        }
        json.put("varyCachingEnabled", obj.isVaryCachingEnabled());
    }
}

