/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.client.OAuth2WebClientOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.Oauth2WebClientAware;

@VertxGen
public interface OAuth2WebClient
extends WebClient {
    public static OAuth2WebClient create(WebClient webClient, OAuth2Auth oAuth2Auth) {
        return OAuth2WebClient.create(webClient, oAuth2Auth, new OAuth2WebClientOptions());
    }

    public static OAuth2WebClient create(WebClient webClient, OAuth2Auth oAuth2Auth, OAuth2WebClientOptions options) {
        return new Oauth2WebClientAware(webClient, oAuth2Auth, options);
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public OAuth2WebClient withCredentials(Credentials var1);

    @Override
    @GenIgnore
    public OAuth2WebClient addInterceptor(Handler<HttpContext<?>> var1);

    public User getUser();
}

