/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.ClientUri;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.uritemplate.UriTemplate;
import io.vertx.uritemplate.Variables;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpRequestImpl<T>
implements HttpRequest<T> {
    private final WebClientBase client;
    private ProxyOptions proxyOptions;
    private final Address address;
    private MultiMap queryParams;
    private Variables templateParams;
    private HttpMethod method;
    private final UriTemplate absoluteUri;
    private int port;
    private String host;
    private String virtualHost;
    private Object uri;
    private long timeout = -1L;
    private long idleTimeout = -1L;
    private long connectTimeout = -1L;
    private String routingKey;
    private boolean followRedirects;
    private Boolean ssl;
    private boolean multipartMixed = true;
    private String traceOperation;
    private BodyCodec<T> codec;
    MultiMap headers;

    HttpRequestImpl(WebClientBase client, HttpMethod method, Address address, UriTemplate absoluteUri, BodyCodec<T> codec, boolean followRedirects, ProxyOptions proxyOptions, MultiMap headers) {
        Objects.requireNonNull(absoluteUri, "AbsoluteUri cannot be null");
        this.client = client;
        this.absoluteUri = absoluteUri;
        this.address = address;
        this.method = method;
        this.ssl = null;
        this.host = null;
        this.port = -1;
        this.uri = null;
        this.codec = codec;
        this.headers = headers;
        this.followRedirects = followRedirects;
        this.proxyOptions = proxyOptions;
    }

    HttpRequestImpl(WebClientBase client, HttpMethod method, Address address, Boolean ssl, int port, String host, Object uri, BodyCodec<T> codec, boolean followRedirects, ProxyOptions proxyOptions, MultiMap headers) {
        Objects.requireNonNull(host, "Host cannot be null");
        this.client = client;
        this.absoluteUri = null;
        this.address = address;
        this.method = method;
        this.ssl = ssl;
        this.port = port;
        this.host = host;
        this.uri = uri;
        this.codec = codec;
        this.headers = headers;
        this.followRedirects = followRedirects;
        this.proxyOptions = proxyOptions;
    }

    private HttpRequestImpl(HttpRequestImpl<T> other) {
        this.client = other.client;
        this.absoluteUri = other.absoluteUri;
        this.address = other.address;
        this.ssl = other.ssl;
        this.method = other.method;
        this.port = other.port;
        this.host = other.host;
        this.uri = other.uri;
        this.codec = other.codec;
        this.headers = other.headers != null ? HttpHeaders.headers().addAll(other.headers) : HttpHeaders.headers();
        this.followRedirects = other.followRedirects;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.timeout = other.timeout;
        this.idleTimeout = other.idleTimeout;
        this.connectTimeout = other.connectTimeout;
        this.routingKey = other.routingKey;
        this.queryParams = other.queryParams != null ? MultiMap.caseInsensitiveMultiMap().addAll(other.queryParams) : null;
        this.multipartMixed = other.multipartMixed;
        this.virtualHost = other.virtualHost;
    }

    @Override
    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        this.codec = responseCodec;
        return this;
    }

    @Override
    public BodyCodec<T> bodyCodec() {
        return this.codec;
    }

    @Override
    public HttpRequest<T> method(HttpMethod value) {
        this.method = value;
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public HttpRequest<T> ssl(Boolean value) {
        this.ssl = value;
        return this;
    }

    @Override
    public Boolean ssl() {
        return this.ssl;
    }

    @Override
    public HttpRequest<T> port(int value) {
        this.port = value;
        return this;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public HttpRequest<T> host(String value) {
        Objects.requireNonNull(this.host, "Host cannot be null");
        this.host = value;
        return this;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public HttpRequest<T> uri(String value) {
        this.queryParams = null;
        this.uri = value;
        return this;
    }

    @Override
    public String uri() {
        return this.uri.toString();
    }

    @Override
    public HttpRequest<T> virtualHost(String value) {
        this.virtualHost = value;
        return this;
    }

    @Override
    public String virtualHost() {
        return this.virtualHost;
    }

    @Override
    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.headers().addAll(headers);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.headers();
        }
        return this.headers;
    }

    @Override
    public HttpRequest<T> authentication(Credentials credentials) {
        this.putHeader(HttpHeaders.AUTHORIZATION.toString(), credentials.toHttpAuthorization());
        return this;
    }

    @Override
    public HttpRequest<T> timeout(long value) {
        this.timeout = value;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public HttpRequest<T> idleTimeout(long timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    @Override
    public long idleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public HttpRequest<T> connectTimeout(long timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public long connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.queryParams().add(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.queryParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, String paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, List<String> paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, Map<String, String> paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> followRedirects(boolean value) {
        this.followRedirects = value;
        return this;
    }

    @Override
    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public HttpRequest<T> routingKey(String key) {
        this.routingKey = key;
        return this;
    }

    @Override
    public String routingKey() {
        return this.routingKey;
    }

    @Override
    public HttpRequest<T> proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    @Override
    public ProxyOptions proxy() {
        return this.proxyOptions;
    }

    @Override
    public MultiMap queryParams() {
        if (this.queryParams == null) {
            int idx;
            this.queryParams = MultiMap.caseInsensitiveMultiMap();
            if (this.uri instanceof String && (idx = ((String)this.uri).indexOf(63)) >= 0) {
                QueryStringDecoder dec = new QueryStringDecoder((String)this.uri);
                dec.parameters().forEach((name, value) -> this.queryParams.add(name, (Iterable)value));
                this.uri = ((String)this.uri).substring(0, idx);
            }
        }
        return this.queryParams;
    }

    @Override
    public Variables templateParams() {
        if (!(this.uri instanceof UriTemplate) && !(this.absoluteUri instanceof UriTemplate)) {
            throw new IllegalStateException();
        }
        if (this.templateParams == null) {
            this.templateParams = Variables.variables();
        }
        return this.templateParams;
    }

    @Override
    public HttpRequest<T> copy() {
        return new HttpRequestImpl<T>(this);
    }

    @Override
    public HttpRequest<T> multipartMixed(boolean allow) {
        this.multipartMixed = allow;
        return this;
    }

    @Override
    public HttpRequest<T> traceOperation(String traceOperation) {
        this.traceOperation = traceOperation;
        return this;
    }

    @Override
    public String traceOperation() {
        return this.traceOperation;
    }

    @Override
    public boolean multipartMixed() {
        return this.multipartMixed;
    }

    @Override
    public Future<HttpResponse<T>> sendStream(ReadStream<Buffer> body) {
        return this.send(null, body);
    }

    @Override
    public Future<HttpResponse<T>> send() {
        return this.send(null, null);
    }

    @Override
    public Future<HttpResponse<T>> sendBuffer(Buffer body) {
        return this.send(null, body);
    }

    @Override
    public Future<HttpResponse<T>> sendJsonObject(JsonObject body) {
        return this.send("application/json", body);
    }

    @Override
    public Future<HttpResponse<T>> sendJson(Object body) {
        return this.send("application/json", body);
    }

    @Override
    public Future<HttpResponse<T>> sendForm(MultiMap body) {
        return this.sendForm(body, "UTF-8");
    }

    @Override
    public Future<HttpResponse<T>> sendForm(MultiMap body, String charset) {
        MultipartForm parts = MultipartForm.create();
        for (Map.Entry attribute : body) {
            parts.attribute((String)attribute.getKey(), (String)attribute.getValue());
        }
        parts.setCharset(charset);
        return this.send("application/x-www-form-urlencoded", parts);
    }

    @Override
    public Future<HttpResponse<T>> sendMultipartForm(MultipartForm body) {
        return this.send("multipart/form-data", body);
    }

    RequestOptions buildRequestOptions() throws URISyntaxException, MalformedURLException {
        String protocol = null;
        Boolean ssl = null;
        int port = -1;
        String host = null;
        String uri = null;
        if (this.absoluteUri != null) {
            uri = this.absoluteUri.expandToString(this.templateParams(), this.client.options.getTemplateExpandOptions());
            ClientUri curi = ClientUri.parse(uri);
            uri = curi.uri;
            host = curi.host;
            port = curi.port;
            protocol = curi.protocol;
            ssl = curi.ssl;
        }
        if (this.ssl != null) {
            ssl = this.ssl;
        }
        if (this.port >= 0) {
            port = this.port;
        }
        if (this.host != null) {
            host = this.host;
        }
        if (this.uri != null) {
            uri = this.uri instanceof String ? (String)this.uri : ((UriTemplate)this.uri).expandToString(this.templateParams(), this.client.options.getTemplateExpandOptions());
        }
        if (this.queryParams != null) {
            uri = HttpRequestImpl.buildUri(uri, this.queryParams);
        }
        RequestOptions requestOptions = new RequestOptions();
        if (protocol != null && !protocol.equals("http") && !protocol.equals("https")) {
            URI tmp = new URI(protocol, null, host, port, uri, null, null);
            requestOptions.setServer(this.address).setMethod(this.method).setAbsoluteURI(tmp.toString());
        } else {
            requestOptions.setServer(this.address).setMethod(this.method).setHost(host).setPort(Integer.valueOf(port)).setURI(uri);
            if (ssl != null) {
                requestOptions.setSsl(ssl);
            }
        }
        if (this.virtualHost != null) {
            if (requestOptions.getServer() == null) {
                requestOptions.setServer((Address)SocketAddress.inetSocketAddress((int)requestOptions.getPort(), (String)requestOptions.getHost()));
            }
            requestOptions.setHost(this.virtualHost);
        }
        this.mergeHeaders(requestOptions);
        if (this.timeout >= 0L) {
            requestOptions.setTimeout(this.timeout);
        }
        if (this.idleTimeout >= 0L) {
            requestOptions.setIdleTimeout(this.idleTimeout);
        }
        if (this.connectTimeout >= 0L) {
            requestOptions.setConnectTimeout(this.connectTimeout);
        }
        requestOptions.setRoutingKey(this.routingKey);
        requestOptions.setProxyOptions(this.proxyOptions);
        requestOptions.setTraceOperation(this.traceOperation);
        return requestOptions;
    }

    Future<HttpResponse<T>> send(String contentType, Object body) {
        ContextInternal context = ((HttpClientInternal)this.client.client).vertx().getOrCreateContext();
        HttpContext ctx = this.client.createContext(context);
        ctx.prepareRequest(this, contentType, body);
        return ctx.future();
    }

    void mergeHeaders(RequestOptions options) {
        if (this.headers != null) {
            MultiMap tmp = options.getHeaders();
            if (tmp == null) {
                tmp = MultiMap.caseInsensitiveMultiMap();
                options.setHeaders(tmp);
            }
            tmp.addAll(this.headers);
        }
    }

    private static String buildUri(String uri, MultiMap queryParams) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        QueryStringEncoder encoder = new QueryStringEncoder(decoder.rawPath());
        decoder.parameters().forEach((name, values) -> {
            for (String value : values) {
                encoder.addParam(name, value);
            }
        });
        queryParams.forEach(param -> encoder.addParam((String)param.getKey(), (String)param.getValue()));
        uri = encoder.toString();
        return uri;
    }
}

