/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.http.HttpHeadersInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.web.multipart.FormDataPart;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class MultipartFormUpload
implements ReadStream<Buffer> {
    private static final Object END_SENTINEL = new Object();
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private DefaultFullHttpRequest request;
    private HttpPostRequestEncoder encoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private final InboundMessageQueue<Object> pending;
    private boolean writable;
    private boolean ended;
    private final ContextInternal context;

    public MultipartFormUpload(Context context, MultipartForm parts, boolean multipart, HttpPostRequestEncoder.EncoderMode encoderMode) throws Exception {
        this.context = (ContextInternal)context;
        this.writable = true;
        this.pending = new InboundMessageQueue<Object>(((ContextInternal)context).eventLoop(), ((ContextInternal)context).executor()){

            protected void handleResume() {
                MultipartFormUpload.this.writable = true;
                MultipartFormUpload.this.pump();
            }

            protected void handlePause() {
                MultipartFormUpload.this.writable = false;
            }

            protected void handleMessage(Object msg) {
                MultipartFormUpload.this.handleChunk(msg);
            }
        };
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        parts.getCharset();
        final Charset charset = parts.getCharset() != null ? parts.getCharset() : HttpConstants.DEFAULT_CHARSET;
        this.encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(16384L, charset){

            public Attribute createAttribute(HttpRequest request, String name, String value) {
                try {
                    return new MemoryAttribute(name, value, charset);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public FileUpload createFileUpload(HttpRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset _charset, long size) {
                if (_charset == null) {
                    _charset = charset;
                }
                return super.createFileUpload(request, name, filename, contentType, contentTransferEncoding, _charset, size);
            }
        }, (HttpRequest)this.request, multipart, charset, encoderMode);
        for (FormDataPart formDataPart : parts) {
            if (formDataPart.isAttribute()) {
                this.encoder.addBodyAttribute(formDataPart.name(), formDataPart.value());
                continue;
            }
            String pathname = formDataPart.pathname();
            if (pathname != null) {
                this.encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), new File(formDataPart.pathname()), formDataPart.mediaType(), formDataPart.isText().booleanValue());
                continue;
            }
            String contentType = formDataPart.mediaType();
            if (formDataPart.mediaType() == null) {
                contentType = formDataPart.isText() != false ? "text/plain" : "application/octet-stream";
            }
            String transferEncoding = formDataPart.isText() != false ? null : "binary";
            MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name(), formDataPart.filename(), contentType, transferEncoding, null, (long)formDataPart.content().length());
            fileUpload.setContent(((BufferInternal)formDataPart.content()).getByteBuf());
            this.encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        this.encoder.finalizeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(Object item) {
        Object handler;
        MultipartFormUpload multipartFormUpload = this;
        synchronized (multipartFormUpload) {
            if (item instanceof Buffer) {
                handler = this.dataHandler;
            } else if (item instanceof Throwable) {
                handler = this.exceptionHandler;
            } else if (item == END_SENTINEL) {
                handler = this.endHandler;
                item = null;
            } else {
                return;
            }
        }
        handler.handle(item);
    }

    public void pump() {
        if (!this.context.inThread()) {
            throw new IllegalArgumentException();
        }
        while (!this.ended) {
            if (this.encoder.isChunked()) {
                try {
                    HttpContent chunk = this.encoder.readChunk((ByteBufAllocator)ALLOC);
                    ByteBuf content = chunk.content();
                    BufferInternal buff = BufferInternal.buffer((ByteBuf)content);
                    this.pending.write((Object)buff);
                    if (this.encoder.isEndOfInput()) {
                        this.ended = true;
                        this.request = null;
                        this.encoder = null;
                        this.pending.write(END_SENTINEL);
                        continue;
                    }
                    if (this.writable) continue;
                }
                catch (Exception e) {
                    this.ended = true;
                    this.request = null;
                    this.encoder = null;
                    this.pending.write((Object)e);
                }
                break;
            }
            ByteBuf content = this.request.content();
            BufferInternal buffer = BufferInternal.buffer((ByteBuf)content);
            this.request = null;
            this.encoder = null;
            this.pending.write((Object)buffer);
            this.ended = true;
            this.pending.write(END_SENTINEL);
        }
    }

    public MultiMap headers() {
        return HttpHeadersInternal.headers((HttpHeaders)this.request.headers());
    }

    public synchronized MultipartFormUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload pause() {
        this.pending.pause();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    public synchronized MultipartFormUpload resume() {
        this.pending.fetch(Long.MAX_VALUE);
        return this;
    }

    public synchronized MultipartFormUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

