/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpClientInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.ClientUri;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.WebClientInternal;
import io.vertx.ext.web.client.impl.predicate.PredicateInterceptor;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import io.vertx.uritemplate.ExpandOptions;
import io.vertx.uritemplate.UriTemplate;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WebClientBase
implements WebClientInternal {
    final HttpClient client;
    final WebClientOptions options;
    final List<Handler<HttpContext<?>>> interceptors;

    public WebClientBase(HttpClient client, WebClientOptions options) {
        options = new WebClientOptions(options);
        if (options.getTemplateExpandOptions() == null) {
            options.setTemplateExpandOptions(new ExpandOptions());
        }
        this.client = client;
        this.options = options;
        this.interceptors = new CopyOnWriteArrayList();
        this.addInterceptor(new PredicateInterceptor());
    }

    WebClientBase(WebClientBase webClient) {
        this.client = webClient.client;
        this.options = new WebClientOptions(webClient.options);
        this.interceptors = new CopyOnWriteArrayList(webClient.interceptors);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, UriTemplate requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, BodyCodecImpl.BUFFER, this.options, null);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, RequestOptions requestOptions) {
        String host;
        Integer port = requestOptions.getPort();
        if (port == null) {
            port = this.options.getDefaultPort();
        }
        if ((host = requestOptions.getHost()) == null) {
            host = this.options.getDefaultHost();
        }
        HttpRequest request = this.request(method, serverAddress, (int)port, host, requestOptions.getURI());
        ((HttpRequestImpl)request).ssl(requestOptions.isSsl());
        return requestOptions.getHeaders() == null ? request : ((HttpRequestImpl)request).putHeaders(requestOptions.getHeaders());
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String host, String requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String host, UriTemplate requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), host, requestURI);
    }

    public HttpRequestImpl<Buffer> request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options, null);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, int port, String host, UriTemplate requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options, null);
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, SocketAddress serverAddress, String surl) {
        ClientUri curi;
        try {
            curi = ClientUri.parse(surl);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new VertxException((Throwable)e);
        }
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, curi.ssl, curi.port, curi.host, curi.uri, BodyCodecImpl.BUFFER, this.options, null);
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, SocketAddress serverAddress, UriTemplate absoluteURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, absoluteURI, BodyCodecImpl.BUFFER, this.options, null);
    }

    @Override
    public WebClientInternal addInterceptor(Handler<HttpContext<?>> interceptor) {
        if (this.interceptors.stream().anyMatch(i -> i.getClass() == interceptor.getClass())) {
            throw new IllegalStateException(String.format("Client already contains a %s interceptor", interceptor.getClass()));
        }
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> HttpContext<T> createContext(Handler<AsyncResult<HttpResponse<T>>> handler) {
        HttpClientInternal client = (HttpClientInternal)this.client;
        return new HttpContext<T>(client, this.options, this.interceptors, handler);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

