/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.predicate;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.ext.web.client.impl.ClientPhase;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.client.impl.predicate.ResponsePredicateResultImpl;
import io.vertx.ext.web.client.predicate.ErrorConverter;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import java.util.ArrayList;
import java.util.List;

public class PredicateInterceptor
implements Handler<HttpContext<?>> {
    public void handle(HttpContext<?> httpContext) {
        if (httpContext.phase() == ClientPhase.RECEIVE_RESPONSE) {
            HttpRequestImpl request = (HttpRequestImpl)httpContext.request();
            HttpClientResponse resp = httpContext.clientResponse();
            List<ResponsePredicate> expectations = request.expectations;
            if (expectations != null) {
                for (ResponsePredicate expectation : expectations) {
                    ResponsePredicateResultImpl predicateResult;
                    try {
                        predicateResult = (ResponsePredicateResultImpl)expectation.apply(this.responseCopy(resp, null));
                    }
                    catch (Exception e) {
                        httpContext.fail(e);
                        return;
                    }
                    if (predicateResult.succeeded()) continue;
                    ErrorConverter errorConverter = expectation.errorConverter();
                    if (!errorConverter.requiresBody()) {
                        this.failOnPredicate(httpContext, errorConverter, predicateResult);
                    } else {
                        resp.bodyHandler(buffer -> {
                            predicateResult.setHttpResponse(this.responseCopy(resp, buffer));
                            this.failOnPredicate(httpContext, errorConverter, predicateResult);
                        });
                        resp.resume();
                    }
                    return;
                }
            }
        }
        httpContext.next();
    }

    private <B> HttpResponseImpl<B> responseCopy(HttpClientResponse resp, B value) {
        return new HttpResponseImpl<B>(resp.version(), resp.statusCode(), resp.statusMessage(), MultiMap.caseInsensitiveMultiMap().addAll(resp.headers()), null, new ArrayList<String>(resp.cookies()), value);
    }

    private void failOnPredicate(HttpContext<?> ctx, ErrorConverter converter, ResponsePredicateResultImpl predicateResult) {
        Throwable result;
        try {
            result = converter.apply(predicateResult);
        }
        catch (Exception e) {
            result = e;
        }
        if (result != null) {
            ctx.fail(result);
        } else {
            ctx.fail((Throwable)new NoStackTraceThrowable("Invalid HTTP response"));
        }
    }
}

