/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.WebClientSessionAware;
import io.vertx.ext.web.client.spi.CookieStore;
import java.util.List;

public class SessionAwareInterceptor
implements Handler<HttpContext<?>> {
    private static final String HEADERS_CONTEXT_KEY = "_originalHeaders";

    public void handle(HttpContext<?> context) {
        switch (context.phase()) {
            case PREPARE_REQUEST: {
                this.prepareRequest(context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.processResponse(context);
                break;
            }
        }
        context.next();
    }

    private void prepareRequest(HttpContext<?> context) {
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        WebClientSessionAware webclient = (WebClientSessionAware)request.client;
        MultiMap headers = (MultiMap)context.get(HEADERS_CONTEXT_KEY);
        if (headers == null) {
            headers = new CaseInsensitiveHeaders().addAll(request.headers());
            context.set(HEADERS_CONTEXT_KEY, headers);
        }
        request.headers().clear().addAll(headers).addAll((MultiMap)webclient.headers());
        String domain = request.virtualHost;
        if (domain == null) {
            domain = request.host;
        }
        Iterable<Cookie> cookies = webclient.cookieStore().get(request.ssl, domain, request.uri);
        for (Cookie c : cookies) {
            request.headers().add("cookie", ClientCookieEncoder.STRICT.encode(c));
        }
    }

    private void processResponse(HttpContext<?> context) {
        List<String> cookieHeaders = context.response().cookies();
        if (cookieHeaders == null) {
            return;
        }
        WebClientSessionAware webclient = (WebClientSessionAware)((HttpRequestImpl)context.request()).client;
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        CookieStore cookieStore = webclient.cookieStore();
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode(header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(request.virtualHost != null ? request.virtualHost : request.host);
                }
                cookieStore.put(cookie);
            }
        });
    }
}

