/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import java.util.List;

class HttpResponseImpl<T>
implements HttpResponse<T> {
    private final HttpClientResponse resp;
    private Buffer buff;
    private T body;

    HttpResponseImpl(HttpClientResponse resp, Buffer buff, T body) {
        this.resp = resp;
        this.buff = buff;
        this.body = body;
    }

    @Override
    public HttpVersion version() {
        return this.resp.version();
    }

    @Override
    public int statusCode() {
        return this.resp.statusCode();
    }

    @Override
    public String statusMessage() {
        return this.resp.statusMessage();
    }

    @Override
    public String getHeader(String headerName) {
        return this.resp.getHeader(headerName);
    }

    @Override
    public MultiMap trailers() {
        return this.resp.trailers();
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.resp.getTrailer(trailerName);
    }

    @Override
    public List<String> cookies() {
        return this.resp.cookies();
    }

    @Override
    public MultiMap headers() {
        return this.resp.headers();
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Buffer bodyAsBuffer() {
        return this.buff != null ? this.buff : (this.body instanceof Buffer ? (Buffer)this.body : null);
    }

    @Override
    public JsonArray bodyAsJsonArray() {
        Buffer b = this.bodyAsBuffer();
        return b != null ? (JsonArray)BodyCodecImpl.JSON_ARRAY_DECODER.apply(b) : null;
    }
}

