/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.client;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.core.impl.ReadStreamSubscriber;
import io.vertx.reactivex.ext.web.client.HttpResponse;
import io.vertx.reactivex.ext.web.codec.BodyCodec;

@RxGen(value=io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {
    public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg(obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest)obj), HttpRequest::getDelegate);
    private final io.vertx.ext.web.client.HttpRequest delegate;
    public final TypeArg<T> __typeArg_0;
    private MultiMap cached_0;

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.ext.web.client.HttpRequest getDelegate() {
        return this.delegate;
    }

    public HttpRequest<T> method(HttpMethod value) {
        this.delegate.method(value);
        return this;
    }

    public HttpRequest<T> port(int value) {
        this.delegate.port(value);
        return this;
    }

    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> host(String value) {
        this.delegate.host(value);
        return this;
    }

    public HttpRequest<T> uri(String value) {
        this.delegate.uri(value);
        return this;
    }

    public HttpRequest<T> putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.headers());
        return ret;
    }

    public HttpRequest<T> ssl(boolean value) {
        this.delegate.ssl(value);
        return this;
    }

    public HttpRequest<T> timeout(long value) {
        this.delegate.timeout(value);
        return this;
    }

    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.delegate.addQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.delegate.setQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> followRedirects(boolean value) {
        this.delegate.followRedirects(value);
        return this;
    }

    public MultiMap queryParams() {
        MultiMap ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.queryParams());
        return ret;
    }

    public HttpRequest<T> copy() {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.copy(), this.__typeArg_0);
        return ret;
    }

    public void sendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream((ReadStream<Buffer>)body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body) {
        return new AsyncResultSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendStream(Flowable<io.vertx.reactivex.core.buffer.Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream((ReadStream<Buffer>)ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(Flowable<io.vertx.reactivex.core.buffer.Buffer> body) {
        return new AsyncResultSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendStream(Observable<io.vertx.reactivex.core.buffer.Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream((ReadStream<Buffer>)ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendStream(Observable<io.vertx.reactivex.core.buffer.Buffer> body) {
        return new AsyncResultSingle(handler -> this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendBuffer(io.vertx.reactivex.core.buffer.Buffer body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendBuffer(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendBuffer(io.vertx.reactivex.core.buffer.Buffer body) {
        return new AsyncResultSingle(handler -> this.sendBuffer(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendJsonObject(JsonObject body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJsonObject(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendJsonObject(JsonObject body) {
        return new AsyncResultSingle(handler -> this.sendJsonObject(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendJson(Object body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJson(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendJson(Object body) {
        return new AsyncResultSingle(handler -> this.sendJson(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void sendForm(MultiMap body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body) {
        return new AsyncResultSingle(handler -> this.sendForm(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public void send(final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.send(new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<HttpResponse<T>> rxSend() {
        return new AsyncResultSingle(handler -> this.send((Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
        return arg != null ? new HttpRequest<T>(arg) : null;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
    }
}

