require 'vertx-web-api-contract/custom_validator'
require 'vertx-web-api-contract/parameter_type_validator'
require 'vertx-web/routing_context'
require 'vertx-web-api-contract/validation_handler'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.validation.HTTPRequestValidationHandler
module VertxWebApiContract
  #  An interface for add HTTP Request validation. This class can validate parameters inside query, path, headers an
  #  body (watch below)
  #  <br/>
  #  You can assign multiple body type at the same time(for example a JSON schema together with a XML schema). This
  #  interface support:
  #  <ul>
  #  <li>application/x-www-form-urlencoded</li>
  #  <li>multipart/form-data</li>
  #  <li>application/xml</li>
  #  <li>application/json</li>
  #  </ul>
  #  Also you can add a form parameter for validation without care about content type of your request. For form
  #  parameters this interface support both "multipart/form-data" and "application/x-www-form-urlencoded"
  #  <br/>
  #  This interface allow extra parameters in the request, so it doesn't care if in a request there's a parameter
  #  without a specified validation rule
  #  <br/>
  #  If a parameter is flagged as an array, it will be validated also if the size of array is 1 element
  class HTTPRequestValidationHandler
    include ::VertxWebApiContract::ValidationHandler
    # @private
    # @param j_del [::VertxWebApiContract::HTTPRequestValidationHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::HTTPRequestValidationHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HTTPRequestValidationHandler
    end
    def @@j_api_type.wrap(obj)
      HTTPRequestValidationHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiValidation::HTTPRequestValidationHandler.java_class
    end
    # @param [::VertxWeb::RoutingContext] arg0 
    # @return [void]
    def handle(arg0=nil)
      if arg0.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(arg0.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{arg0})"
    end
    #  Factory method to create an HTTPRequestValidationHandler
    # @return [::VertxWebApiContract::HTTPRequestValidationHandler] new HTTPRequestValidationHandler
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::HTTPRequestValidationHandler.java_method(:create, []).call(),::VertxWebApiContract::HTTPRequestValidationHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
    #  Add a path parameter with included parameter types. All path params are <b>required</b>
    # @param [String] parameterName expected name of parameter inside the path
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of parameter
    # @return [self]
    def add_path_param(parameterName=nil,type=nil)
      if parameterName.class == String && type.class == Symbol && !block_given?
        @j_del.java_method(:addPathParam, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class]).call(parameterName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_path_param(#{parameterName},#{type})"
    end
    #  Add a path parameter with a custom pattern. All path params are <b>required</b>
    # @param [String] parameterName expected name of parameter inside the path
    # @param [String] pattern regular expression for validation
    # @return [self]
    def add_path_param_with_pattern(parameterName=nil,pattern=nil)
      if parameterName.class == String && pattern.class == String && !block_given?
        @j_del.java_method(:addPathParamWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(parameterName,pattern)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_path_param_with_pattern(#{parameterName},#{pattern})"
    end
    #  Add a path parameter with a custom type validator. All path params are <b>required</b>. For more informations
    #  about how to construct built-in or custom type validator, check out {::VertxWebApiContract::ParameterTypeValidator}
    # @param [String] parameterName expected name of parameter inside the path
    # @param [::VertxWebApiContract::ParameterTypeValidator] validator type validator
    # @param [true,false] allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {::VertxWebApiContract::ParameterValidationRule#allow_empty_value}
    # @return [self]
    def add_path_param_with_custom_type_validator(parameterName=nil,validator=nil,allowEmptyValue=nil)
      if parameterName.class == String && validator.class.method_defined?(:j_del) && (allowEmptyValue.class == TrueClass || allowEmptyValue.class == FalseClass) && !block_given?
        @j_del.java_method(:addPathParamWithCustomTypeValidator, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class,Java::boolean.java_class]).call(parameterName,validator.j_del,allowEmptyValue)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_path_param_with_custom_type_validator(#{parameterName},#{validator},#{allowEmptyValue})"
    end
    #  Add a query parameter with included parameter types
    # @param [String] parameterName expected name of parameter inside the query
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of parameter
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_query_param(parameterName=nil,type=nil,required=nil)
      if parameterName.class == String && type.class == Symbol && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addQueryParam, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class,Java::boolean.java_class]).call(parameterName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s),required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_query_param(#{parameterName},#{type},#{required})"
    end
    #  Add a query parameter with a custom pattern
    # @param [String] parameterName expected name of parameter inside the query
    # @param [String] pattern regular expression for validation
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_query_param_with_pattern(parameterName=nil,pattern=nil,required=nil)
      if parameterName.class == String && pattern.class == String && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addQueryParamWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(parameterName,pattern,required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_query_param_with_pattern(#{parameterName},#{pattern},#{required})"
    end
    #  Add a query parameters array with included parameter types
    # @param [String] arrayName expected name of array inside the query
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of parameter
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_query_params_array(arrayName=nil,type=nil,required=nil)
      if arrayName.class == String && type.class == Symbol && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addQueryParamsArray, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class,Java::boolean.java_class]).call(arrayName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s),required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_query_params_array(#{arrayName},#{type},#{required})"
    end
    #  Add a query parameters array with a custom pattern
    # @param [String] arrayName expected name of array inside the query
    # @param [String] pattern regular expression for validation
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_query_params_array_with_pattern(arrayName=nil,pattern=nil,required=nil)
      if arrayName.class == String && pattern.class == String && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addQueryParamsArrayWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(arrayName,pattern,required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_query_params_array_with_pattern(#{arrayName},#{pattern},#{required})"
    end
    #  Add a query parameter with a custom type validator. For more informations about how to construct built-in or
    #  custom type validator, check out {::VertxWebApiContract::ParameterTypeValidator}
    # @param [String] parameterName expected name of parameter inside the query
    # @param [::VertxWebApiContract::ParameterTypeValidator] validator type validator
    # @param [true,false] required true if parameter is required
    # @param [true,false] allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {::VertxWebApiContract::ParameterValidationRule#allow_empty_value}
    # @return [self]
    def add_query_param_with_custom_type_validator(parameterName=nil,validator=nil,required=nil,allowEmptyValue=nil)
      if parameterName.class == String && validator.class.method_defined?(:j_del) && (required.class == TrueClass || required.class == FalseClass) && (allowEmptyValue.class == TrueClass || allowEmptyValue.class == FalseClass) && !block_given?
        @j_del.java_method(:addQueryParamWithCustomTypeValidator, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(parameterName,validator.j_del,required,allowEmptyValue)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_query_param_with_custom_type_validator(#{parameterName},#{validator},#{required},#{allowEmptyValue})"
    end
    #  Add a header parameter with included parameter types
    # @param [String] headerName expected header name
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of parameter
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_header_param(headerName=nil,type=nil,required=nil)
      if headerName.class == String && type.class == Symbol && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addHeaderParam, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class,Java::boolean.java_class]).call(headerName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s),required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_header_param(#{headerName},#{type},#{required})"
    end
    #  Add a header parameter with a custom pattern
    # @param [String] headerName expected header name
    # @param [String] pattern regular expression for validation
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_header_param_with_pattern(headerName=nil,pattern=nil,required=nil)
      if headerName.class == String && pattern.class == String && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addHeaderParamWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(headerName,pattern,required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_header_param_with_pattern(#{headerName},#{pattern},#{required})"
    end
    #  Add a header parameter with a custom type validator. For more informations about how to construct built-in or
    #  custom type validator, check out {::VertxWebApiContract::ParameterTypeValidator}
    # @param [String] headerName expected header namery
    # @param [::VertxWebApiContract::ParameterTypeValidator] validator type validator
    # @param [true,false] required true if parameter is required
    # @param [true,false] allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {::VertxWebApiContract::ParameterValidationRule#allow_empty_value}
    # @return [self]
    def add_header_param_with_custom_type_validator(headerName=nil,validator=nil,required=nil,allowEmptyValue=nil)
      if headerName.class == String && validator.class.method_defined?(:j_del) && (required.class == TrueClass || required.class == FalseClass) && (allowEmptyValue.class == TrueClass || allowEmptyValue.class == FalseClass) && !block_given?
        @j_del.java_method(:addHeaderParamWithCustomTypeValidator, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(headerName,validator.j_del,required,allowEmptyValue)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_header_param_with_custom_type_validator(#{headerName},#{validator},#{required},#{allowEmptyValue})"
    end
    #  Add a single parameter inside a form with included parameter types
    # @param [String] parameterName expected name of parameter inside the form
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of parameter
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_form_param(parameterName=nil,type=nil,required=nil)
      if parameterName.class == String && type.class == Symbol && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addFormParam, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class,Java::boolean.java_class]).call(parameterName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s),required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_form_param(#{parameterName},#{type},#{required})"
    end
    #  Add a single parameter inside a form with a custom pattern
    # @param [String] parameterName expected name of parameter inside the form
    # @param [String] pattern regular expression for validation
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_form_param_with_pattern(parameterName=nil,pattern=nil,required=nil)
      if parameterName.class == String && pattern.class == String && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addFormParamWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(parameterName,pattern,required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_form_param_with_pattern(#{parameterName},#{pattern},#{required})"
    end
    #  Add a form parameters array with included parameter types
    # @param [String] parameterName expected name of array of parameters inside the form
    # @param [:GENERIC_STRING,:EMAIL,:URI,:BOOL,:INT,:FLOAT,:DOUBLE,:DATE,:DATETIME,:TIME,:BASE64,:IPV4,:IPV6,:HOSTNAME] type expected type of array of parameters
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_form_params_array(parameterName=nil,type=nil,required=nil)
      if parameterName.class == String && type.class == Symbol && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addFormParamsArray, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterType.java_class,Java::boolean.java_class]).call(parameterName,Java::IoVertxExtWebApiValidation::ParameterType.valueOf(type.to_s),required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_form_params_array(#{parameterName},#{type},#{required})"
    end
    #  Add a form parameters array with a custom pattern
    # @param [String] parameterName expected name of array of parameters inside the form
    # @param [String] pattern regular expression for validation
    # @param [true,false] required true if parameter is required
    # @return [self]
    def add_form_params_array_with_pattern(parameterName=nil,pattern=nil,required=nil)
      if parameterName.class == String && pattern.class == String && (required.class == TrueClass || required.class == FalseClass) && !block_given?
        @j_del.java_method(:addFormParamsArrayWithPattern, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(parameterName,pattern,required)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_form_params_array_with_pattern(#{parameterName},#{pattern},#{required})"
    end
    #  Add a form parameter with a custom type validator. For more informations about how to construct built-in or
    #  custom type validator, check out {::VertxWebApiContract::ParameterTypeValidator}
    # @param [String] parameterName expected name of parameter inside the form
    # @param [::VertxWebApiContract::ParameterTypeValidator] validator type validator
    # @param [true,false] required true if parameter is required
    # @param [true,false] allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {::VertxWebApiContract::ParameterValidationRule#allow_empty_value}
    # @return [self]
    def add_form_param_with_custom_type_validator(parameterName=nil,validator=nil,required=nil,allowEmptyValue=nil)
      if parameterName.class == String && validator.class.method_defined?(:j_del) && (required.class == TrueClass || required.class == FalseClass) && (allowEmptyValue.class == TrueClass || allowEmptyValue.class == FalseClass) && !block_given?
        @j_del.java_method(:addFormParamWithCustomTypeValidator, [Java::java.lang.String.java_class,Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(parameterName,validator.j_del,required,allowEmptyValue)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_form_param_with_custom_type_validator(#{parameterName},#{validator},#{required},#{allowEmptyValue})"
    end
    #  Add a custom validator. For more informations about custom validator, see {::VertxWebApiContract::CustomValidator}
    # @param [::VertxWebApiContract::CustomValidator] customValidator 
    # @return [self]
    def add_custom_validator_function(customValidator=nil)
      if customValidator.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addCustomValidatorFunction, [Java::IoVertxExtWebApiValidation::CustomValidator.java_class]).call(customValidator.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_custom_validator_function(#{customValidator})"
    end
    #  Add a json schema for body with Content-Type "application/json"
    # @param [String] jsonSchema 
    # @return [self]
    def add_json_body_schema(jsonSchema=nil)
      if jsonSchema.class == String && !block_given?
        @j_del.java_method(:addJsonBodySchema, [Java::java.lang.String.java_class]).call(jsonSchema)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_json_body_schema(#{jsonSchema})"
    end
    #  Add a xml schema for body with Content-Type "application/xml"
    # @param [String] xmlSchema 
    # @return [self]
    def add_xml_body_schema(xmlSchema=nil)
      if xmlSchema.class == String && !block_given?
        @j_del.java_method(:addXMLBodySchema, [Java::java.lang.String.java_class]).call(xmlSchema)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_xml_body_schema(#{xmlSchema})"
    end
    #  Add an expected filename inside <b>multipart request</b>.
    # @param [String] filename name of the file inside the form
    # @param [String] contentType expected content type of file
    # @return [self]
    def add_multipart_required_file(filename=nil,contentType=nil)
      if filename.class == String && contentType.class == String && !block_given?
        @j_del.java_method(:addMultipartRequiredFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(filename,contentType)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_multipart_required_file(#{filename},#{contentType})"
    end
    #  Add an expected content type of request. It's not needed to add application/json, application/xml,
    #  multipart/form-data and application/x-www-form-urlencoded
    # @param [String] contentType expected content type of file
    # @return [self]
    def add_expected_content_type(contentType=nil)
      if contentType.class == String && !block_given?
        @j_del.java_method(:addExpectedContentType, [Java::java.lang.String.java_class]).call(contentType)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_expected_content_type(#{contentType})"
    end
  end
end
