require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.validation.ContainerDeserializer
module VertxWebApiContract
  #  Interface that define methods for deserialization of array and objects
  class ContainerDeserializer
    # @private
    # @param j_del [::VertxWebApiContract::ContainerDeserializer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::ContainerDeserializer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ContainerDeserializer
    end
    def @@j_api_type.wrap(obj)
      ContainerDeserializer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiValidation::ContainerDeserializer.java_class
    end
    # @param [String] serialized 
    # @return [Array<String>]
    def deserialize_array(serialized=nil)
      if serialized.class == String && !block_given?
        return @j_del.java_method(:deserializeArray, [Java::java.lang.String.java_class]).call(serialized).to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling deserialize_array(#{serialized})"
    end
    # @param [String] serialized 
    # @return [Hash{String => String}]
    def deserialize_object(serialized=nil)
      if serialized.class == String && !block_given?
        return Java::IoVertxLangRuby::Helper.adaptingMap(@j_del.java_method(:deserializeObject, [Java::java.lang.String.java_class]).call(serialized), Proc.new { |val| ::Vertx::Util::Utils.from_object(val) }, Proc.new { |val| ::Vertx::Util::Utils.to_string(val) })
      end
      raise ArgumentError, "Invalid arguments when calling deserialize_object(#{serialized})"
    end
  end
end
