/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import java.util.List;

public class OneOfTypeValidator
implements ParameterTypeValidator {
    List<ParameterTypeValidator> validators;

    public OneOfTypeValidator(List<ParameterTypeValidator> validators) {
        this.validators = validators;
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        RequestParameter resultParam = null;
        for (ParameterTypeValidator validator : this.validators) {
            try {
                RequestParameter validatedParam = validator.isValid(value);
                if (validatedParam == null) continue;
                if (resultParam == null) {
                    resultParam = validatedParam;
                    continue;
                }
                throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(value + " match multiple schemas inside oneOf field");
            }
            catch (ValidationException validationException) {
            }
        }
        if (resultParam != null) {
            return resultParam;
        }
        throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(value + " doesn't match any of oneOf schemas");
    }
}

