/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Command;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.Topic;
import io.vertx.ext.stomp.utils.Headers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventBusBridge
extends Topic {
    private final BridgeOptions options;
    private final Map<String, Pattern> expressions = new HashMap<String, Pattern>();
    private final Map<String, MessageConsumer<?>> registry = new HashMap();

    public EventBusBridge(Vertx vertx, BridgeOptions options) {
        super(vertx, null);
        this.options = options;
    }

    @Override
    public String destination() {
        return "<<bridge>>";
    }

    @Override
    public synchronized Destination subscribe(StompServerConnection connection, Frame frame) {
        String address = frame.getDestination();
        if (this.checkMatches(false, address, null)) {
            Topic.Subscription subscription = new Topic.Subscription(connection, frame);
            this.subscriptions.add(subscription);
            if (!this.registry.containsKey(address)) {
                this.registry.put(address, this.vertx.eventBus().consumer(address, msg -> {
                    if (!this.checkMatches(false, address, msg.body())) {
                        return;
                    }
                    if (this.options.isPointToPoint()) {
                        Optional<Topic.Subscription> chosen = this.subscriptions.stream().filter(s -> s.destination.equals(address)).findAny();
                        if (chosen.isPresent()) {
                            Frame stompFrame = this.transform((Message<Object>)msg, chosen.get());
                            chosen.get().connection.write(stompFrame);
                        }
                    } else {
                        this.subscriptions.stream().filter(s -> s.destination.equals(address)).forEach(s -> {
                            Frame stompFrame = this.transform((Message<Object>)msg, (Topic.Subscription)s);
                            s.connection.write(stompFrame);
                        });
                    }
                }));
            }
            return this;
        }
        return null;
    }

    @Override
    public synchronized boolean unsubscribe(StompServerConnection connection, Frame frame) {
        for (Topic.Subscription subscription : new ArrayList(this.subscriptions)) {
            MessageConsumer<?> consumer;
            if (!subscription.connection.equals(connection) || !subscription.id.equals(frame.getId())) continue;
            boolean r = this.subscriptions.remove(subscription);
            Optional<Topic.Subscription> any = this.subscriptions.stream().filter(s -> s.destination.equals(subscription.destination)).findAny();
            if (!any.isPresent() && (consumer = this.registry.remove(subscription.destination)) != null) {
                consumer.unregister();
            }
            return r;
        }
        return false;
    }

    @Override
    public synchronized Destination unsubscribeConnection(StompServerConnection connection) {
        new ArrayList(this.subscriptions).stream().filter(subscription -> subscription.connection.equals(connection)).forEach(s -> {
            MessageConsumer<?> consumer;
            this.subscriptions.remove(s);
            Optional<Topic.Subscription> any = this.subscriptions.stream().filter(s2 -> s2.destination.equals(s.destination)).findAny();
            if (!any.isPresent() && (consumer = this.registry.remove(s.destination)) != null) {
                consumer.unregister();
            }
        });
        return this;
    }

    private Frame transform(Message<Object> msg, Topic.Subscription subscription) {
        String messageId = UUID.randomUUID().toString();
        Frame frame = new Frame();
        frame.setCommand(Command.MESSAGE);
        Headers headers = Headers.create(frame.getHeaders()).add("subscription", subscription.id).add("message-id", messageId).add("destination", msg.address());
        if (!"auto".equals(subscription.ackMode)) {
            headers.add("ack", messageId);
        }
        if (msg.replyAddress() != null) {
            headers.put("reply-address", msg.replyAddress());
        }
        for (Map.Entry entry : msg.headers()) {
            headers.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
        }
        frame.setHeaders(headers);
        Object body = msg.body();
        if (body != null) {
            if (body instanceof String) {
                frame.setBody(Buffer.buffer((String)((String)body)));
            } else if (body instanceof Buffer) {
                frame.setBody((Buffer)body);
            } else if (body instanceof JsonObject) {
                frame.setBody(Buffer.buffer((String)((JsonObject)body).encode()));
            } else {
                throw new IllegalStateException("Illegal body - unsupported body type: " + body.getClass().getName());
            }
        }
        if (body != null && frame.getHeader("content-length") == null) {
            frame.addHeader("content-length", Integer.toString(frame.getBody().length()));
        }
        return frame;
    }

    @Override
    public Destination dispatch(StompServerConnection connection, Frame frame) {
        String address = frame.getDestination();
        if (this.checkMatches(true, address, frame.getBody())) {
            String replyAddress = frame.getHeader("reply-address");
            if (replyAddress != null) {
                this.send(address, frame, (Handler<AsyncResult<Message<Object>>>)((Handler)res -> {
                    if (res.failed()) {
                        Throwable cause = res.cause();
                        connection.write(Frames.createErrorFrame("Message dispatch error", Headers.create("destination", address, "reply-address", replyAddress), cause.getMessage())).close();
                    } else {
                        Optional<Topic.Subscription> subscription = this.subscriptions.stream().filter(s -> s.connection.equals(connection) && s.destination.equals(replyAddress)).findFirst();
                        if (subscription.isPresent()) {
                            Frame stompFrame = this.transform((Message<Object>)((Message)res.result()), subscription.get());
                            subscription.get().connection.write(stompFrame);
                        }
                    }
                }));
            } else {
                this.send(address, frame, null);
            }
        } else {
            connection.write(Frames.createErrorFrame("Access denied", Headers.create("destination", address), "Access denied to " + address)).close();
            return null;
        }
        return this;
    }

    private void send(String address, Frame frame, Handler<AsyncResult<Message<Object>>> replyHandler) {
        DeliveryOptions deliveryOptions = new DeliveryOptions().setHeaders(this.toMultimap(frame.getHeaders()));
        if (this.options.isPointToPoint()) {
            Future messageFuture = this.vertx.eventBus().request(address, (Object)frame.getBody(), deliveryOptions);
            if (replyHandler != null) {
                messageFuture.onComplete(replyHandler);
            }
        } else {
            this.vertx.eventBus().publish(address, (Object)frame.getBody(), deliveryOptions);
        }
    }

    private MultiMap toMultimap(Map<String, String> headers) {
        return MultiMap.caseInsensitiveMultiMap().addAll(headers);
    }

    public boolean matches(String address, Buffer payload) {
        return this.checkMatches(false, address, payload) || this.checkMatches(true, address, payload);
    }

    @Override
    public boolean matches(String address) {
        return this.checkMatches(false, address, null) || this.checkMatches(true, address, null);
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.expressions.get(matchRegex);
        if (pattern == null) {
            pattern = Pattern.compile(matchRegex);
            this.expressions.put(matchRegex, pattern);
        }
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private boolean checkMatches(boolean inbound, String address, Object body) {
        List matches = inbound ? this.options.getInboundPermitteds() : this.options.getOutboundPermitteds();
        for (PermittedOptions matchHolder : matches) {
            String matchAddress = matchHolder.getAddress();
            String matchRegex = matchAddress == null ? matchHolder.getAddressRegex() : null;
            boolean addressOK = matchAddress == null ? matchRegex == null || this.regexMatches(matchRegex, address) : matchAddress.equals(address);
            if (!addressOK) continue;
            return this.structureMatches(matchHolder.getMatch(), body);
        }
        return false;
    }

    private boolean structureMatches(JsonObject match, Object body) {
        if (match == null || body == null) {
            return true;
        }
        try {
            JsonObject object;
            if (body instanceof JsonObject) {
                object = (JsonObject)body;
            } else if (body instanceof Buffer) {
                object = new JsonObject(((Buffer)body).toString("UTF-8"));
            } else if (body instanceof String) {
                object = new JsonObject((String)body);
            } else {
                return false;
            }
            for (String fieldName : match.fieldNames()) {
                Object mv = match.getValue(fieldName);
                Object bv = object.getValue(fieldName);
                if (!(mv instanceof JsonObject ? !this.structureMatches((JsonObject)mv, bv) : !match.getValue(fieldName).equals(object.getValue(fieldName)))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

