/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.ext.stomp.StompClientOptionsConverter;
import io.vertx.ext.stomp.StompOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class StompClientOptions
extends NetClientOptions
implements StompOptions {
    private static final boolean DEFAULT_CLIENT_REUSE_ADDRESS = false;
    private List<String> acceptedVersions;
    private int port = 61613;
    private String host = "0.0.0.0";
    private String login;
    private String passcode;
    private boolean autoComputeContentLength = true;
    private boolean useStompFrame = false;
    private boolean bypassHostHeader = false;
    private JsonObject heartbeat = DEFAULT_STOMP_HEARTBEAT;
    private String virtualHost;
    private boolean trailingLine = false;

    public StompClientOptions() {
        this.init();
        this.setReuseAddress(false);
    }

    public StompClientOptions(StompClientOptions other) {
        super((NetClientOptions)other);
        this.port = other.port;
        this.host = other.host;
        this.login = other.login;
        this.passcode = other.passcode;
        this.autoComputeContentLength = other.autoComputeContentLength;
        this.acceptedVersions = new ArrayList<String>(other.acceptedVersions);
        this.bypassHostHeader = other.bypassHostHeader;
        this.heartbeat = other.heartbeat;
        this.virtualHost = other.virtualHost;
        this.trailingLine = other.trailingLine;
    }

    public StompClientOptions(JsonObject json) {
        super(json);
        this.init();
        StompClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (!(json.getValue("reuseAddress") instanceof Boolean)) {
            this.setReuseAddress(false);
        }
    }

    private void init() {
        this.acceptedVersions = new ArrayList<String>(DEFAULT_SUPPORTED_VERSIONS);
        Collections.reverse(this.acceptedVersions);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        StompClientOptionsConverter.toJson(this, json);
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public StompClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public String getLogin() {
        return this.login;
    }

    public StompClientOptions setLogin(String login) {
        this.login = login;
        return this;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public StompClientOptions setPasscode(String passcode) {
        this.passcode = passcode;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public StompClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public List<String> getAcceptedVersions() {
        return this.acceptedVersions;
    }

    public StompClientOptions setAcceptedVersions(List<String> acceptedVersions) {
        this.acceptedVersions = acceptedVersions;
        return this;
    }

    public boolean isAutoComputeContentLength() {
        return this.autoComputeContentLength;
    }

    public StompClientOptions setAutoComputeContentLength(boolean autoComputeContentLength) {
        this.autoComputeContentLength = autoComputeContentLength;
        return this;
    }

    public boolean isUseStompFrame() {
        return this.useStompFrame;
    }

    public StompClientOptions setUseStompFrame(boolean useStompFrame) {
        this.useStompFrame = useStompFrame;
        return this;
    }

    public StompClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public boolean isBypassHostHeader() {
        return this.bypassHostHeader;
    }

    public StompClientOptions setBypassHostHeader(boolean bypassHostHeader) {
        this.bypassHostHeader = bypassHostHeader;
        return this;
    }

    public JsonObject getHeartbeat() {
        return this.heartbeat;
    }

    public StompClientOptions setHeartbeat(JsonObject heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public StompClientOptions setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public boolean isTrailingLine() {
        return this.trailingLine;
    }

    public StompClientOptions setTrailingLine(boolean trailingLine) {
        this.trailingLine = trailingLine;
        return this;
    }
}

