/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.StompServerOptions;
import java.util.ArrayList;
import java.util.Map;

public class StompServerOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, StompServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "maxBodyLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxBodyLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaders": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaders(((Number)member.getValue()).intValue());
                    break;
                }
                case "supportedVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSupportedVersions(list);
                    break;
                }
                case "secured": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSecured((Boolean)member.getValue());
                    break;
                }
                case "sendErrorOnNoSubscriptions": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSendErrorOnNoSubscriptions((Boolean)member.getValue());
                    break;
                }
                case "timeFactor": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeFactor(((Number)member.getValue()).intValue());
                    break;
                }
                case "heartbeat": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHeartbeat(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "maxFrameInTransaction": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFrameInTransaction(((Number)member.getValue()).intValue());
                    break;
                }
                case "transactionChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTransactionChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxSubscriptionsByClient": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxSubscriptionsByClient(((Number)member.getValue()).intValue());
                    break;
                }
                case "websocketBridge": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebsocketBridge((Boolean)member.getValue());
                    break;
                }
                case "websocketPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWebsocketPath((String)member.getValue());
                    break;
                }
                case "trailingLine": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTrailingLine((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(StompServerOptions obj, JsonObject json) {
        StompServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(StompServerOptions obj, Map<String, Object> json) {
        json.put("maxBodyLength", obj.getMaxBodyLength());
        json.put("maxHeaderLength", obj.getMaxHeaderLength());
        json.put("maxHeaders", obj.getMaxHeaders());
        if (obj.getSupportedVersions() != null) {
            JsonArray array = new JsonArray();
            obj.getSupportedVersions().forEach(item -> array.add(item));
            json.put("supportedVersions", array);
        }
        json.put("secured", obj.isSecured());
        json.put("sendErrorOnNoSubscriptions", obj.isSendErrorOnNoSubscriptions());
        json.put("timeFactor", obj.getTimeFactor());
        if (obj.getHeartbeat() != null) {
            json.put("heartbeat", obj.getHeartbeat());
        }
        json.put("maxFrameInTransaction", obj.getMaxFrameInTransaction());
        json.put("transactionChunkSize", obj.getTransactionChunkSize());
        json.put("maxSubscriptionsByClient", obj.getMaxSubscriptionsByClient());
        json.put("websocketBridge", obj.isWebsocketBridge());
        if (obj.getWebsocketPath() != null) {
            json.put("websocketPath", obj.getWebsocketPath());
        }
        json.put("trailingLine", obj.isTrailingLine());
    }
}

