/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.stomp.Command;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.FrameException;
import io.vertx.ext.stomp.utils.Headers;
import java.util.Map;
import java.util.Objects;

@VertxGen
public interface Frames {
    public static final Frame PING = new Frame(Command.PING, (Map)Headers.create(), null){

        @Override
        public Buffer toBuffer() {
            return Buffer.buffer((String)"\n");
        }
    };

    public static Frame createErrorFrame(String message, Map<String, String> headers, String body) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        return new Frame(Command.ERROR, Headers.create(headers).add("message", message).add("content-length", Integer.toString(body.length())).add("content-type", "text/plain"), Buffer.buffer((String)body));
    }

    @GenIgnore
    public static Frame createInvalidFrameErrorFrame(FrameException exception) {
        return Frames.createErrorFrame("Invalid frame received", Headers.create(), exception.getMessage());
    }

    public static Frame createReceiptFrame(String receiptId, Map<String, String> headers) {
        Objects.requireNonNull(receiptId);
        Objects.requireNonNull(headers);
        return new Frame(Command.RECEIPT, Headers.create(headers).add("receipt-id", receiptId), null);
    }

    public static void handleReceipt(Frame frame, StompServerConnection connection) {
        String receipt = frame.getReceipt();
        if (receipt != null) {
            connection.write(Frames.createReceiptFrame(receipt, Headers.create()));
        }
    }

    public static Frame ping() {
        return PING;
    }
}

