/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.stomp.Command;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.utils.Headers;
import io.vertx.ext.stomp.utils.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultConnectHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame sf) {
        ArrayList<String> accepted = new ArrayList<String>();
        String accept = sf.frame().getHeader("accept-version");
        if (accept == null) {
            accepted.add("1.0");
        } else {
            accepted.addAll(Arrays.asList(accept.split(",")));
        }
        String version = this.negotiate(accepted, sf.connection());
        if (version == null) {
            sf.connection().write(Frames.createErrorFrame("Incompatible versions", Headers.create("version", this.getSupportedVersionsHeaderLine(sf.connection()), "content-type", "text/plain"), "Client protocol requirement does not mach versions supported by the server. Supported protocol versions are " + this.getSupportedVersionsHeaderLine(sf.connection())));
            sf.connection().close();
            return;
        }
        this.authenticate(sf.frame(), sf.connection(), (Handler<AsyncResult<Void>>)((Handler)ar -> sf.connection().write(new Frame(Command.CONNECTED, Headers.create("version", version, "server", Server.SERVER_NAME, "session", sf.connection().session(), "heart-beat", Frame.Heartbeat.create(sf.connection().server().options().getHeartbeat()).toString()), null))));
    }

    private void authenticate(Frame frame, StompServerConnection connection, Handler<AsyncResult<Void>> remainingActions) {
        if (connection.server().options().isSecured()) {
            String login = frame.getHeader("login");
            String passcode = frame.getHeader("passcode");
            connection.handler().onAuthenticationRequest(connection, login, passcode, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {
                if (((Boolean)ar.result()).booleanValue()) {
                    remainingActions.handle((Object)Future.succeededFuture());
                } else {
                    connection.write(Frames.createErrorFrame("Authentication failed", Headers.create("version", this.getSupportedVersionsHeaderLine(connection), "content-type", "text/plain"), "The connection frame does not contain valid credentials."));
                    connection.close();
                }
            }));
        } else {
            remainingActions.handle((Object)Future.succeededFuture());
        }
    }

    private String getSupportedVersionsHeaderLine(StompServerConnection connection) {
        StringBuilder builder = new StringBuilder();
        connection.server().options().getSupportedVersions().stream().forEach(v -> builder.append(builder.length() == 0 ? v : "," + v));
        return builder.toString();
    }

    private String negotiate(List<String> accepted, StompServerConnection connection) {
        List<String> supported = connection.server().options().getSupportedVersions();
        for (String v : supported) {
            if (!accepted.contains(v)) continue;
            return v;
        }
        return null;
    }
}

