/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.Transactions;
import io.vertx.ext.stomp.utils.Headers;

public class DefaultBeginHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame serverFrame) {
        Frame frame = serverFrame.frame();
        StompServerConnection connection = serverFrame.connection();
        String txId = frame.getHeader("transaction");
        if (txId == null) {
            Frame error = Frames.createErrorFrame("Missing transaction id", Headers.create(), "BEGIN frames must contain the 'transaction' header.");
            connection.write(error).close();
            return;
        }
        if (!Transactions.instance().registerTransaction(connection, txId)) {
            Frame error = Frames.createErrorFrame("Already existing transaction", Headers.create("transaction", txId), "A transaction using the same id is still active.");
            connection.write(error).close();
            return;
        }
        Frames.handleReceipt(frame, connection);
    }
}

