/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.ext.stomp.impl.FrameException;

public class HeaderCodec {
    private static final String ESCAPE_ESCAPE = String.valueOf(new char[]{'\\', '\\'});
    private static final String COLON_ESCAPE = String.valueOf(new char[]{'\\', 'c'});
    private static final String LINE_FEED_ESCAPE = String.valueOf(new char[]{'\\', 'n'});
    private static final String CARRIAGE_RETURN_ESCAPE = String.valueOf(new char[]{'\\', 'r'});

    private HeaderCodec() {
    }

    public static String encode(String header, boolean connectOrConnectedFrame) {
        StringBuilder builder = new StringBuilder();
        block6: for (int i = 0; i < header.length(); ++i) {
            char value = header.charAt(i);
            switch (value) {
                case '\\': {
                    builder.append(ESCAPE_ESCAPE);
                    continue block6;
                }
                case '\n': {
                    if (connectOrConnectedFrame) {
                        builder.append(value);
                        continue block6;
                    }
                    builder.append(LINE_FEED_ESCAPE);
                    continue block6;
                }
                case ':': {
                    if (connectOrConnectedFrame) {
                        builder.append(value);
                        continue block6;
                    }
                    builder.append(COLON_ESCAPE);
                    continue block6;
                }
                case '\r': {
                    if (connectOrConnectedFrame) {
                        builder.append(value);
                        continue block6;
                    }
                    builder.append(CARRIAGE_RETURN_ESCAPE);
                    continue block6;
                }
                default: {
                    builder.append(value);
                }
            }
        }
        return builder.toString();
    }

    public static String decode(String header, boolean connectOrConnectedFrame) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < header.length(); ++i) {
            char value = header.charAt(i);
            if (value == '\\' && i + 1 < header.length()) {
                char next = header.charAt(i + 1);
                switch (next) {
                    case 'r': {
                        if (connectOrConnectedFrame) {
                            builder.append(value);
                            break;
                        }
                        builder.append("\r");
                        ++i;
                        break;
                    }
                    case 'n': {
                        if (connectOrConnectedFrame) {
                            builder.append(value);
                            break;
                        }
                        builder.append('\n');
                        ++i;
                        break;
                    }
                    case 'c': {
                        if (connectOrConnectedFrame) {
                            builder.append(value);
                            break;
                        }
                        builder.append(":");
                        ++i;
                        break;
                    }
                    case '\\': {
                        builder.append('\\');
                        ++i;
                        break;
                    }
                    default: {
                        throw new FrameException("Incorrect header value - the header uses an illegal escaped character '" + next + "' (" + (byte)next + ")");
                    }
                }
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }
}

