/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.ServerFrameImpl;
import io.vertx.ext.stomp.impl.StompServerTCPConnectionImpl;
import java.util.Objects;

public class StompServerWebSocketConnectionImpl
extends StompServerTCPConnectionImpl
implements StompServerConnection {
    private final ServerWebSocket socket;

    public StompServerWebSocketConnectionImpl(ServerWebSocket socket, StompServer server, Handler<ServerFrame> writtenFrameHandler) {
        super(server, writtenFrameHandler);
        Objects.requireNonNull(socket);
        this.socket = socket;
    }

    @Override
    public StompServerConnection write(Buffer buffer) {
        this.socket.write(buffer);
        return this;
    }

    @Override
    public void ping() {
        if (this.handler != null) {
            this.handler.handle((Object)new ServerFrameImpl(Frames.PING, this));
        }
        this.socket.write(Buffer.buffer((String)"\n"));
    }

    @Override
    public void close() {
        this.cancelHeartbeat();
        this.handler().onClose(this);
        try {
            this.socket.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

