/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompClient;
import io.vertx.ext.stomp.StompClientConnection;
import io.vertx.ext.stomp.StompClientOptions;
import io.vertx.ext.stomp.impl.StompClientConnectionImpl;
import io.vertx.ext.stomp.utils.Headers;

public class StompClientImpl
implements StompClient {
    private static final Logger log = LoggerFactory.getLogger(StompClientImpl.class);
    private final Vertx vertx;
    private final StompClientOptions options;
    private NetClient client;

    public StompClientImpl(Vertx vertx, StompClientOptions options) {
        this.vertx = vertx;
        this.options = options;
    }

    @Override
    public StompClient connect(int port, String host, Handler<AsyncResult<StompClientConnection>> resultHandler) {
        return this.connect(port, host, this.vertx.createNetClient((NetClientOptions)this.options), resultHandler);
    }

    @Override
    public StompClient connect(Handler<AsyncResult<StompClientConnection>> resultHandler) {
        return this.connect(this.options.getPort(), this.options.getHost(), this.vertx.createNetClient((NetClientOptions)this.options), resultHandler);
    }

    @Override
    public StompClient connect(NetClient netClient, Handler<AsyncResult<StompClientConnection>> resultHandler) {
        return this.connect(this.options.getPort(), this.options.getHost(), netClient, resultHandler);
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    public StompClientOptions options() {
        return this.options;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public synchronized StompClient connect(int port, String host, NetClient net, Handler<AsyncResult<StompClientConnection>> resultHandler) {
        this.client = net.connect(port, host, ar -> {
            if (ar.failed()) {
                if (resultHandler != null) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                } else {
                    log.error((Object)ar.cause());
                }
            } else {
                new StompClientConnectionImpl(this.vertx, (NetSocket)ar.result(), this, resultHandler);
                ((NetSocket)ar.result()).write(this.getConnectFrame(host));
            }
        });
        return this;
    }

    private Buffer getConnectFrame(String host) {
        Headers headers = Headers.create();
        String accepted = this.getAcceptedVersions();
        if (accepted != null) {
            headers.put("accept-version", accepted);
        }
        if (!this.options.isBypassHostHeader()) {
            headers.put("host", host);
        }
        if (this.options.getVirtualHost() != null) {
            headers.put("host", this.options.getVirtualHost());
        }
        if (this.options.getLogin() != null) {
            headers.put("login", this.options.getLogin());
        }
        if (this.options.getPasscode() != null) {
            headers.put("passcode", this.options.getPasscode());
        }
        headers.put("heart-beat", Frame.Heartbeat.create(this.options.getHeartbeat()).toString());
        Frame.Command cmd = this.options.isUseStompFrame() ? Frame.Command.STOMP : Frame.Command.CONNECT;
        Frame frame = new Frame(cmd, headers, null);
        return frame.toBuffer();
    }

    private String getAcceptedVersions() {
        if (this.options.getAcceptedVersions() == null || this.options.getAcceptedVersions().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.options.getAcceptedVersions().stream().forEach(version -> builder.append(builder.length() == 0 ? version : "," + version));
        return builder.toString();
    }
}

