/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.TxCommand;

public class TransactionImpl
implements Transaction {
    private final ContextInternal context;
    private final Connection connection;
    private final Promise<TxCommand.Kind> completion;
    private final Handler<Void> endHandler;
    private int pendingQueries;
    private boolean ended;
    private boolean failed;
    private TxCommand<?> endCommand;

    public TransactionImpl(ContextInternal context, Handler<Void> endHandler, Connection connection) {
        this.context = context;
        this.connection = connection;
        this.completion = context.promise();
        this.endHandler = endHandler;
    }

    public Future<Transaction> begin() {
        PromiseInternal promise = this.context.promise();
        TxCommand<TransactionImpl> begin = new TxCommand<TransactionImpl>(TxCommand.Kind.BEGIN, this);
        begin.handler = this.wrap((CommandBase<?>)begin, (Completable)promise);
        this.schedule(begin);
        return promise.future();
    }

    public void fail() {
        this.failed = true;
    }

    private <R> void execute(CommandBase<R> cmd) {
        Completable handler = cmd.handler;
        this.connection.schedule(cmd, handler);
    }

    private <T> Completable<T> wrap(CommandBase<?> cmd, Completable<T> handler) {
        return (res, err) -> {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                --this.pendingQueries;
            }
            this.checkEnd();
            handler.complete(res, err);
        };
    }

    public <R> void schedule(CommandBase<R> cmd, Completable<R> handler) {
        cmd.handler = this.wrap(cmd, handler);
        if (!this.schedule(cmd)) {
            handler.fail("Transaction already completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> boolean schedule(CommandBase<R> b) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.ended) {
                return false;
            }
            ++this.pendingQueries;
        }
        this.execute(b);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnd() {
        TxCommand<?> cmd;
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.pendingQueries > 0 || !this.ended || this.endCommand != null) {
                return;
            }
            TxCommand.Kind kind = this.failed ? TxCommand.Kind.ROLLBACK : TxCommand.Kind.COMMIT;
            cmd = this.endCommand = this.txCommand(kind);
        }
        this.endHandler.handle(null);
        this.execute(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<TxCommand.Kind> end(boolean rollback) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.endCommand != null) {
                return this.context.failedFuture("Transaction already complete");
            }
            this.ended = true;
            this.failed |= rollback;
        }
        this.checkEnd();
        return this.completion.future();
    }

    @Override
    public Future<Void> commit() {
        return this.end(false).flatMap(k -> {
            if (k == TxCommand.Kind.COMMIT) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((Throwable)((Object)TransactionRollbackException.INSTANCE));
        });
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.commit();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> rollback() {
        return this.end(true).mapEmpty();
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.rollback();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    private TxCommand<Void> txCommand(TxCommand.Kind kind) {
        TxCommand<Object> cmd = new TxCommand<Object>(kind, null);
        cmd.handler = (res, err) -> {
            if (err == null) {
                this.completion.complete((Object)kind);
            } else {
                this.completion.fail(err);
            }
        };
        return cmd;
    }

    @Override
    public Future<Void> completion() {
        return this.completion.future().flatMap(k -> {
            if (k == TxCommand.Kind.COMMIT) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((Throwable)((Object)TransactionRollbackException.INSTANCE));
        });
    }
}

