/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.internal.RowInternal;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class RowDecoder<C, R> {
    private final Collector<Row, C, R> collector;
    private BiConsumer<C, Row> accumulator;
    private RowInternal row;
    private int size;
    private C container;
    private Throwable failure;
    private R result;

    protected RowDecoder(Collector<Row, C, R> collector) {
        this.collector = collector;
        this.reset();
    }

    protected abstract RowInternal row();

    public int size() {
        return this.size;
    }

    protected abstract boolean decodeRow(int var1, ByteBuf var2, Row var3);

    public void handleRow(int len, ByteBuf in) {
        RowInternal r = this.row;
        if (r == null) {
            r = this.row();
        } else {
            this.row = null;
        }
        boolean decoded = this.decodeRow(len, in, r);
        if (decoded && this.failure == null) {
            if (this.accumulator == null) {
                try {
                    this.accumulator = this.collector.accumulator();
                }
                catch (Exception e) {
                    this.failure = e;
                    return;
                }
            }
            try {
                this.accumulator.accept(this.container, r);
            }
            catch (Exception e) {
                this.failure = e;
                return;
            }
            if (r.tryRecycle()) {
                this.row = r;
            }
            ++this.size;
        }
    }

    public R result() {
        return this.result;
    }

    public Throwable complete() {
        try {
            this.result = this.collector.finisher().apply(this.container);
        }
        catch (Exception e) {
            this.failure = e;
        }
        return this.failure;
    }

    public void reset() {
        this.size = 0;
        this.failure = null;
        this.result = null;
        try {
            this.container = this.collector.supplier().get();
        }
        catch (Exception e) {
            this.failure = e;
        }
    }
}

