/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public abstract class RowDesc {
    private final ColumnNames columnNames;
    private final ColumnDescriptors columnDescriptors;

    protected RowDesc(ColumnDescriptor[] columnDescriptors) {
        this.columnNames = new ColumnNames(columnDescriptors);
        this.columnDescriptors = new ColumnDescriptors(columnDescriptors);
    }

    public int columnIndex(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must not be null");
        }
        return this.columnNames.indexOf(columnName);
    }

    public List<String> columnNames() {
        return this.columnNames;
    }

    public List<ColumnDescriptor> columnDescriptor() {
        return this.columnDescriptors;
    }

    public String toString() {
        return "RowDesc{columns=" + this.columnNames + '}';
    }

    private static class ColumnDescriptors
    extends AbstractList<ColumnDescriptor>
    implements RandomAccess {
        final ColumnDescriptor[] elements;

        ColumnDescriptors(ColumnDescriptor[] elements) {
            this.elements = elements;
        }

        @Override
        public ColumnDescriptor get(int index) {
            return this.elements[index];
        }

        @Override
        public int size() {
            return this.elements.length;
        }
    }

    private static class ColumnNames
    extends AbstractList<String>
    implements RandomAccess {
        final ColumnDescriptor[] elements;

        ColumnNames(ColumnDescriptor[] elements) {
            this.elements = elements;
        }

        @Override
        public String get(int index) {
            return this.elements[index].name();
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public int indexOf(Object o) {
            if (o != null) {
                for (int i = 0; i < this.elements.length; ++i) {
                    String name = this.elements[i].name();
                    if (o.hashCode() != name.hashCode() || !o.equals(name)) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

